/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextSimilarityReranker
extends RetrieverBase
implements RetrieverVariant {
    private final Retriever retriever;
    @Nullable
    private final Integer rankWindowSize;
    @Nullable
    private final String inferenceId;
    private final String inferenceText;
    private final String field;
    public static final JsonpDeserializer<TextSimilarityReranker> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextSimilarityReranker::setupTextSimilarityRerankerDeserializer);

    private TextSimilarityReranker(Builder builder) {
        super(builder);
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.rankWindowSize = builder.rankWindowSize;
        this.inferenceId = builder.inferenceId;
        this.inferenceText = ApiTypeHelper.requireNonNull(builder.inferenceText, this, "inferenceText");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
    }

    public static TextSimilarityReranker of(Function<Builder, ObjectBuilder<TextSimilarityReranker>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.TextSimilarityReranker;
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    @Nullable
    public final String inferenceId() {
        return this.inferenceId;
    }

    public final String inferenceText() {
        return this.inferenceText;
    }

    public final String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
        if (this.inferenceId != null) {
            generator.writeKey("inference_id");
            generator.write(this.inferenceId);
        }
        generator.writeKey("inference_text");
        generator.write(this.inferenceText);
        generator.writeKey("field");
        generator.write(this.field);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTextSimilarityRerankerDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
        op.add(Builder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(Builder::inferenceText, JsonpDeserializer.stringDeserializer(), "inference_text");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TextSimilarityReranker> {
        private Retriever retriever;
        @Nullable
        private Integer rankWindowSize;
        @Nullable
        private String inferenceId;
        private String inferenceText;
        private String field;

        public Builder() {
        }

        private Builder(TextSimilarityReranker instance) {
            this.retriever = instance.retriever;
            this.rankWindowSize = instance.rankWindowSize;
            this.inferenceId = instance.inferenceId;
            this.inferenceText = instance.inferenceText;
            this.field = instance.field;
        }

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        public final Builder inferenceId(@Nullable String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder inferenceText(String value) {
            this.inferenceText = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextSimilarityReranker build() {
            this._checkSingleUse();
            return new TextSimilarityReranker(this);
        }
    }
}

