/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchStats
implements JsonpSerializable {
    private final long fetchCurrent;
    @Nullable
    private final Time fetchTime;
    private final long fetchTimeInMillis;
    private final long fetchTotal;
    @Nullable
    private final Long openContexts;
    private final long queryCurrent;
    @Nullable
    private final Time queryTime;
    private final long queryTimeInMillis;
    private final long queryTotal;
    private final long scrollCurrent;
    @Nullable
    private final Time scrollTime;
    private final long scrollTimeInMillis;
    private final long scrollTotal;
    private final long suggestCurrent;
    @Nullable
    private final Time suggestTime;
    private final long suggestTimeInMillis;
    private final long suggestTotal;
    private final Map<String, SearchStats> groups;
    public static final JsonpDeserializer<SearchStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchStats::setupSearchStatsDeserializer);

    private SearchStats(Builder builder) {
        this.fetchCurrent = ApiTypeHelper.requireNonNull(builder.fetchCurrent, (Object)this, "fetchCurrent", 0L);
        this.fetchTime = builder.fetchTime;
        this.fetchTimeInMillis = ApiTypeHelper.requireNonNull(builder.fetchTimeInMillis, (Object)this, "fetchTimeInMillis", 0L);
        this.fetchTotal = ApiTypeHelper.requireNonNull(builder.fetchTotal, (Object)this, "fetchTotal", 0L);
        this.openContexts = builder.openContexts;
        this.queryCurrent = ApiTypeHelper.requireNonNull(builder.queryCurrent, (Object)this, "queryCurrent", 0L);
        this.queryTime = builder.queryTime;
        this.queryTimeInMillis = ApiTypeHelper.requireNonNull(builder.queryTimeInMillis, (Object)this, "queryTimeInMillis", 0L);
        this.queryTotal = ApiTypeHelper.requireNonNull(builder.queryTotal, (Object)this, "queryTotal", 0L);
        this.scrollCurrent = ApiTypeHelper.requireNonNull(builder.scrollCurrent, (Object)this, "scrollCurrent", 0L);
        this.scrollTime = builder.scrollTime;
        this.scrollTimeInMillis = ApiTypeHelper.requireNonNull(builder.scrollTimeInMillis, (Object)this, "scrollTimeInMillis", 0L);
        this.scrollTotal = ApiTypeHelper.requireNonNull(builder.scrollTotal, (Object)this, "scrollTotal", 0L);
        this.suggestCurrent = ApiTypeHelper.requireNonNull(builder.suggestCurrent, (Object)this, "suggestCurrent", 0L);
        this.suggestTime = builder.suggestTime;
        this.suggestTimeInMillis = ApiTypeHelper.requireNonNull(builder.suggestTimeInMillis, (Object)this, "suggestTimeInMillis", 0L);
        this.suggestTotal = ApiTypeHelper.requireNonNull(builder.suggestTotal, (Object)this, "suggestTotal", 0L);
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
    }

    public static SearchStats of(Function<Builder, ObjectBuilder<SearchStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long fetchCurrent() {
        return this.fetchCurrent;
    }

    @Nullable
    public final Time fetchTime() {
        return this.fetchTime;
    }

    public final long fetchTimeInMillis() {
        return this.fetchTimeInMillis;
    }

    public final long fetchTotal() {
        return this.fetchTotal;
    }

    @Nullable
    public final Long openContexts() {
        return this.openContexts;
    }

    public final long queryCurrent() {
        return this.queryCurrent;
    }

    @Nullable
    public final Time queryTime() {
        return this.queryTime;
    }

    public final long queryTimeInMillis() {
        return this.queryTimeInMillis;
    }

    public final long queryTotal() {
        return this.queryTotal;
    }

    public final long scrollCurrent() {
        return this.scrollCurrent;
    }

    @Nullable
    public final Time scrollTime() {
        return this.scrollTime;
    }

    public final long scrollTimeInMillis() {
        return this.scrollTimeInMillis;
    }

    public final long scrollTotal() {
        return this.scrollTotal;
    }

    public final long suggestCurrent() {
        return this.suggestCurrent;
    }

    @Nullable
    public final Time suggestTime() {
        return this.suggestTime;
    }

    public final long suggestTimeInMillis() {
        return this.suggestTimeInMillis;
    }

    public final long suggestTotal() {
        return this.suggestTotal;
    }

    public final Map<String, SearchStats> groups() {
        return this.groups;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fetch_current");
        generator.write(this.fetchCurrent);
        if (this.fetchTime != null) {
            generator.writeKey("fetch_time");
            this.fetchTime.serialize(generator, mapper);
        }
        generator.writeKey("fetch_time_in_millis");
        generator.write(this.fetchTimeInMillis);
        generator.writeKey("fetch_total");
        generator.write(this.fetchTotal);
        if (this.openContexts != null) {
            generator.writeKey("open_contexts");
            generator.write(this.openContexts.longValue());
        }
        generator.writeKey("query_current");
        generator.write(this.queryCurrent);
        if (this.queryTime != null) {
            generator.writeKey("query_time");
            this.queryTime.serialize(generator, mapper);
        }
        generator.writeKey("query_time_in_millis");
        generator.write(this.queryTimeInMillis);
        generator.writeKey("query_total");
        generator.write(this.queryTotal);
        generator.writeKey("scroll_current");
        generator.write(this.scrollCurrent);
        if (this.scrollTime != null) {
            generator.writeKey("scroll_time");
            this.scrollTime.serialize(generator, mapper);
        }
        generator.writeKey("scroll_time_in_millis");
        generator.write(this.scrollTimeInMillis);
        generator.writeKey("scroll_total");
        generator.write(this.scrollTotal);
        generator.writeKey("suggest_current");
        generator.write(this.suggestCurrent);
        if (this.suggestTime != null) {
            generator.writeKey("suggest_time");
            this.suggestTime.serialize(generator, mapper);
        }
        generator.writeKey("suggest_time_in_millis");
        generator.write(this.suggestTimeInMillis);
        generator.writeKey("suggest_total");
        generator.write(this.suggestTotal);
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartObject();
            for (Map.Entry<String, SearchStats> item0 : this.groups.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSearchStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fetchCurrent, JsonpDeserializer.longDeserializer(), "fetch_current");
        op.add(Builder::fetchTime, Time._DESERIALIZER, "fetch_time");
        op.add(Builder::fetchTimeInMillis, JsonpDeserializer.longDeserializer(), "fetch_time_in_millis");
        op.add(Builder::fetchTotal, JsonpDeserializer.longDeserializer(), "fetch_total");
        op.add(Builder::openContexts, JsonpDeserializer.longDeserializer(), "open_contexts");
        op.add(Builder::queryCurrent, JsonpDeserializer.longDeserializer(), "query_current");
        op.add(Builder::queryTime, Time._DESERIALIZER, "query_time");
        op.add(Builder::queryTimeInMillis, JsonpDeserializer.longDeserializer(), "query_time_in_millis");
        op.add(Builder::queryTotal, JsonpDeserializer.longDeserializer(), "query_total");
        op.add(Builder::scrollCurrent, JsonpDeserializer.longDeserializer(), "scroll_current");
        op.add(Builder::scrollTime, Time._DESERIALIZER, "scroll_time");
        op.add(Builder::scrollTimeInMillis, JsonpDeserializer.longDeserializer(), "scroll_time_in_millis");
        op.add(Builder::scrollTotal, JsonpDeserializer.longDeserializer(), "scroll_total");
        op.add(Builder::suggestCurrent, JsonpDeserializer.longDeserializer(), "suggest_current");
        op.add(Builder::suggestTime, Time._DESERIALIZER, "suggest_time");
        op.add(Builder::suggestTimeInMillis, JsonpDeserializer.longDeserializer(), "suggest_time_in_millis");
        op.add(Builder::suggestTotal, JsonpDeserializer.longDeserializer(), "suggest_total");
        op.add(Builder::groups, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "groups");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchStats> {
        private Long fetchCurrent;
        @Nullable
        private Time fetchTime;
        private Long fetchTimeInMillis;
        private Long fetchTotal;
        @Nullable
        private Long openContexts;
        private Long queryCurrent;
        @Nullable
        private Time queryTime;
        private Long queryTimeInMillis;
        private Long queryTotal;
        private Long scrollCurrent;
        @Nullable
        private Time scrollTime;
        private Long scrollTimeInMillis;
        private Long scrollTotal;
        private Long suggestCurrent;
        @Nullable
        private Time suggestTime;
        private Long suggestTimeInMillis;
        private Long suggestTotal;
        @Nullable
        private Map<String, SearchStats> groups;

        public Builder() {
        }

        private Builder(SearchStats instance) {
            this.fetchCurrent = instance.fetchCurrent;
            this.fetchTime = instance.fetchTime;
            this.fetchTimeInMillis = instance.fetchTimeInMillis;
            this.fetchTotal = instance.fetchTotal;
            this.openContexts = instance.openContexts;
            this.queryCurrent = instance.queryCurrent;
            this.queryTime = instance.queryTime;
            this.queryTimeInMillis = instance.queryTimeInMillis;
            this.queryTotal = instance.queryTotal;
            this.scrollCurrent = instance.scrollCurrent;
            this.scrollTime = instance.scrollTime;
            this.scrollTimeInMillis = instance.scrollTimeInMillis;
            this.scrollTotal = instance.scrollTotal;
            this.suggestCurrent = instance.suggestCurrent;
            this.suggestTime = instance.suggestTime;
            this.suggestTimeInMillis = instance.suggestTimeInMillis;
            this.suggestTotal = instance.suggestTotal;
            this.groups = instance.groups;
        }

        public final Builder fetchCurrent(long value) {
            this.fetchCurrent = value;
            return this;
        }

        public final Builder fetchTime(@Nullable Time value) {
            this.fetchTime = value;
            return this;
        }

        public final Builder fetchTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fetchTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder fetchTimeInMillis(long value) {
            this.fetchTimeInMillis = value;
            return this;
        }

        public final Builder fetchTotal(long value) {
            this.fetchTotal = value;
            return this;
        }

        public final Builder openContexts(@Nullable Long value) {
            this.openContexts = value;
            return this;
        }

        public final Builder queryCurrent(long value) {
            this.queryCurrent = value;
            return this;
        }

        public final Builder queryTime(@Nullable Time value) {
            this.queryTime = value;
            return this;
        }

        public final Builder queryTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.queryTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder queryTimeInMillis(long value) {
            this.queryTimeInMillis = value;
            return this;
        }

        public final Builder queryTotal(long value) {
            this.queryTotal = value;
            return this;
        }

        public final Builder scrollCurrent(long value) {
            this.scrollCurrent = value;
            return this;
        }

        public final Builder scrollTime(@Nullable Time value) {
            this.scrollTime = value;
            return this;
        }

        public final Builder scrollTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scrollTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder scrollTimeInMillis(long value) {
            this.scrollTimeInMillis = value;
            return this;
        }

        public final Builder scrollTotal(long value) {
            this.scrollTotal = value;
            return this;
        }

        public final Builder suggestCurrent(long value) {
            this.suggestCurrent = value;
            return this;
        }

        public final Builder suggestTime(@Nullable Time value) {
            this.suggestTime = value;
            return this;
        }

        public final Builder suggestTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.suggestTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder suggestTimeInMillis(long value) {
            this.suggestTimeInMillis = value;
            return this;
        }

        public final Builder suggestTotal(long value) {
            this.suggestTotal = value;
            return this;
        }

        public final Builder groups(Map<String, SearchStats> map) {
            this.groups = Builder._mapPutAll(this.groups, map);
            return this;
        }

        public final Builder groups(String key, SearchStats value) {
            this.groups = Builder._mapPut(this.groups, key, value);
            return this;
        }

        public final Builder groups(String key, Function<Builder, ObjectBuilder<SearchStats>> fn) {
            return this.groups(key, fn.apply(new Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchStats build() {
            this._checkSingleUse();
            return new SearchStats(this);
        }
    }
}

