/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.GlobalOrdinalFieldStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GlobalOrdinalsStats
implements JsonpSerializable {
    private final long buildTimeInMillis;
    @Nullable
    private final String buildTime;
    private final Map<String, GlobalOrdinalFieldStats> fields;
    public static final JsonpDeserializer<GlobalOrdinalsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GlobalOrdinalsStats::setupGlobalOrdinalsStatsDeserializer);

    private GlobalOrdinalsStats(Builder builder) {
        this.buildTimeInMillis = ApiTypeHelper.requireNonNull(builder.buildTimeInMillis, (Object)this, "buildTimeInMillis", 0L);
        this.buildTime = builder.buildTime;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static GlobalOrdinalsStats of(Function<Builder, ObjectBuilder<GlobalOrdinalsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long buildTimeInMillis() {
        return this.buildTimeInMillis;
    }

    @Nullable
    public final String buildTime() {
        return this.buildTime;
    }

    public final Map<String, GlobalOrdinalFieldStats> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_time_in_millis");
        generator.write(this.buildTimeInMillis);
        if (this.buildTime != null) {
            generator.writeKey("build_time");
            generator.write(this.buildTime);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, GlobalOrdinalFieldStats> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGlobalOrdinalsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildTimeInMillis, JsonpDeserializer.longDeserializer(), "build_time_in_millis");
        op.add(Builder::buildTime, JsonpDeserializer.stringDeserializer(), "build_time");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(GlobalOrdinalFieldStats._DESERIALIZER), "fields");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GlobalOrdinalsStats> {
        private Long buildTimeInMillis;
        @Nullable
        private String buildTime;
        @Nullable
        private Map<String, GlobalOrdinalFieldStats> fields;

        public Builder() {
        }

        private Builder(GlobalOrdinalsStats instance) {
            this.buildTimeInMillis = instance.buildTimeInMillis;
            this.buildTime = instance.buildTime;
            this.fields = instance.fields;
        }

        public final Builder buildTimeInMillis(long value) {
            this.buildTimeInMillis = value;
            return this;
        }

        public final Builder buildTime(@Nullable String value) {
            this.buildTime = value;
            return this;
        }

        public final Builder fields(Map<String, GlobalOrdinalFieldStats> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, GlobalOrdinalFieldStats value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<GlobalOrdinalFieldStats.Builder, ObjectBuilder<GlobalOrdinalFieldStats>> fn) {
            return this.fields(key, fn.apply(new GlobalOrdinalFieldStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GlobalOrdinalsStats build() {
            this._checkSingleUse();
            return new GlobalOrdinalsStats(this);
        }
    }
}

