/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldSizeUsage
implements JsonpSerializable {
    @Nullable
    private final String size;
    private final long sizeInBytes;
    public static final JsonpDeserializer<FieldSizeUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSizeUsage::setupFieldSizeUsageDeserializer);

    private FieldSizeUsage(Builder builder) {
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
    }

    public static FieldSizeUsage of(Function<Builder, ObjectBuilder<FieldSizeUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldSizeUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldSizeUsage> {
        @Nullable
        private String size;
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(FieldSizeUsage instance) {
            this.size = instance.size;
            this.sizeInBytes = instance.sizeInBytes;
        }

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldSizeUsage build() {
            this._checkSingleUse();
            return new FieldSizeUsage(this);
        }
    }
}

