/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.StopTrainedModelDeploymentResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StopTrainedModelDeploymentRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String id;
    private final String modelId;
    public static final JsonpDeserializer<StopTrainedModelDeploymentRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopTrainedModelDeploymentRequest::setupStopTrainedModelDeploymentRequestDeserializer);
    public static final Endpoint<StopTrainedModelDeploymentRequest, StopTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StopTrainedModelDeploymentRequest, StopTrainedModelDeploymentResponse>("es/ml.stop_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, StopTrainedModelDeploymentResponse._DESERIALIZER);

    private StopTrainedModelDeploymentRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.id = builder.id;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
    }

    public static StopTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<StopTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoMatch != null) {
            generator.writeKey("allow_no_match");
            generator.write(this.allowNoMatch.booleanValue());
        }
        if (this.force != null) {
            generator.writeKey("force");
            generator.write(this.force.booleanValue());
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
    }

    protected static void setupStopTrainedModelDeploymentRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoMatch, JsonpDeserializer.booleanDeserializer(), "allow_no_match");
        op.add(Builder::force, JsonpDeserializer.booleanDeserializer(), "force");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopTrainedModelDeploymentRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        @Nullable
        private String id;
        private String modelId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new StopTrainedModelDeploymentRequest(this);
        }
    }
}

