/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: indices._types.DataStreamOptionsTemplate

/**
 * Data stream options template contains the same information as
 * DataStreamOptions but allows them to be set explicitly to null.
 * 
 * @see <a href=
 *      "../doc-files/api-spec.html#indices._types.DataStreamOptionsTemplate">API
 *      specification</a>
 */
@JsonpDeserializable
public class DataStreamOptionsTemplate implements JsonpSerializable {
	@Nullable
	private final DataStreamFailureStoreTemplate failureStore;

	// ---------------------------------------------------------------------------------------------

	private DataStreamOptionsTemplate(Builder builder) {

		this.failureStore = builder.failureStore;

	}

	public static DataStreamOptionsTemplate of(Function<Builder, ObjectBuilder<DataStreamOptionsTemplate>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * API name: {@code failure_store}
	 */
	@Nullable
	public final DataStreamFailureStoreTemplate failureStore() {
		return this.failureStore;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		if (this.failureStore != null) {
			generator.writeKey("failure_store");
			this.failureStore.serialize(generator, mapper);

		}

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link DataStreamOptionsTemplate}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder>
			implements
				ObjectBuilder<DataStreamOptionsTemplate> {
		@Nullable
		private DataStreamFailureStoreTemplate failureStore;

		/**
		 * API name: {@code failure_store}
		 */
		public final Builder failureStore(@Nullable DataStreamFailureStoreTemplate value) {
			this.failureStore = value;
			return this;
		}

		/**
		 * API name: {@code failure_store}
		 */
		public final Builder failureStore(
				Function<DataStreamFailureStoreTemplate.Builder, ObjectBuilder<DataStreamFailureStoreTemplate>> fn) {
			return this.failureStore(fn.apply(new DataStreamFailureStoreTemplate.Builder()).build());
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link DataStreamOptionsTemplate}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public DataStreamOptionsTemplate build() {
			_checkSingleUse();

			return new DataStreamOptionsTemplate(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link DataStreamOptionsTemplate}
	 */
	public static final JsonpDeserializer<DataStreamOptionsTemplate> _DESERIALIZER = ObjectBuilderDeserializer
			.lazy(Builder::new, DataStreamOptionsTemplate::setupDataStreamOptionsTemplateDeserializer);

	protected static void setupDataStreamOptionsTemplateDeserializer(
			ObjectDeserializer<DataStreamOptionsTemplate.Builder> op) {

		op.add(Builder::failureStore, DataStreamFailureStoreTemplate._DESERIALIZER, "failure_store");

	}

}
