/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfigVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ZeroShotClassificationInferenceOptions
implements InferenceConfigCreateVariant,
JsonpSerializable {
    @Nullable
    private final TokenizationConfig tokenization;
    @Nullable
    private final String hypothesisTemplate;
    private final List<String> classificationLabels;
    @Nullable
    private final String resultsField;
    @Nullable
    private final Boolean multiLabel;
    private final List<String> labels;
    public static final JsonpDeserializer<ZeroShotClassificationInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ZeroShotClassificationInferenceOptions::setupZeroShotClassificationInferenceOptionsDeserializer);

    private ZeroShotClassificationInferenceOptions(Builder builder) {
        this.tokenization = builder.tokenization;
        this.hypothesisTemplate = builder.hypothesisTemplate;
        this.classificationLabels = ApiTypeHelper.unmodifiableRequired(builder.classificationLabels, (Object)this, "classificationLabels");
        this.resultsField = builder.resultsField;
        this.multiLabel = builder.multiLabel;
        this.labels = ApiTypeHelper.unmodifiable(builder.labels);
    }

    public static ZeroShotClassificationInferenceOptions of(Function<Builder, ObjectBuilder<ZeroShotClassificationInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.ZeroShotClassification;
    }

    @Nullable
    public final TokenizationConfig tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String hypothesisTemplate() {
        return this.hypothesisTemplate;
    }

    public final List<String> classificationLabels() {
        return this.classificationLabels;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Boolean multiLabel() {
        return this.multiLabel;
    }

    public final List<String> labels() {
        return this.labels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.hypothesisTemplate != null) {
            generator.writeKey("hypothesis_template");
            generator.write(this.hypothesisTemplate);
        }
        if (ApiTypeHelper.isDefined(this.classificationLabels)) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String item0 : this.classificationLabels) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.multiLabel != null) {
            generator.writeKey("multi_label");
            generator.write(this.multiLabel.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.labels)) {
            generator.writeKey("labels");
            generator.writeStartArray();
            for (String item0 : this.labels) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupZeroShotClassificationInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokenization, TokenizationConfig._DESERIALIZER, "tokenization");
        op.add(Builder::hypothesisTemplate, JsonpDeserializer.stringDeserializer(), "hypothesis_template");
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::multiLabel, JsonpDeserializer.booleanDeserializer(), "multi_label");
        op.add(Builder::labels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "labels");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ZeroShotClassificationInferenceOptions> {
        @Nullable
        private TokenizationConfig tokenization;
        @Nullable
        private String hypothesisTemplate;
        private List<String> classificationLabels;
        @Nullable
        private String resultsField;
        @Nullable
        private Boolean multiLabel;
        @Nullable
        private List<String> labels;

        public final Builder tokenization(@Nullable TokenizationConfig value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<TokenizationConfig.Builder, ObjectBuilder<TokenizationConfig>> fn) {
            return this.tokenization(fn.apply(new TokenizationConfig.Builder()).build());
        }

        public final Builder tokenization(TokenizationConfigVariant value) {
            this.tokenization = value._toTokenizationConfig();
            return this;
        }

        public final Builder hypothesisTemplate(@Nullable String value) {
            this.hypothesisTemplate = value;
            return this;
        }

        public final Builder classificationLabels(List<String> list) {
            this.classificationLabels = Builder._listAddAll(this.classificationLabels, list);
            return this;
        }

        public final Builder classificationLabels(String value, String ... values) {
            this.classificationLabels = Builder._listAdd(this.classificationLabels, value, values);
            return this;
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder multiLabel(@Nullable Boolean value) {
            this.multiLabel = value;
            return this;
        }

        public final Builder labels(List<String> list) {
            this.labels = Builder._listAddAll(this.labels, list);
            return this;
        }

        public final Builder labels(String value, String ... values) {
            this.labels = Builder._listAdd(this.labels, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ZeroShotClassificationInferenceOptions build() {
            this._checkSingleUse();
            return new ZeroShotClassificationInferenceOptions(this);
        }
    }
}

