/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    @Nullable
    private final Long indexedVectorCount;
    @Nullable
    private final Long indexedVectorDimMax;
    @Nullable
    private final Long indexedVectorDimMin;
    @Nullable
    private final Integer scriptCount;
    public static final JsonpDeserializer<FieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypes::setupFieldTypesDeserializer);

    private FieldTypes(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0);
        this.indexedVectorCount = builder.indexedVectorCount;
        this.indexedVectorDimMax = builder.indexedVectorDimMax;
        this.indexedVectorDimMin = builder.indexedVectorDimMin;
        this.scriptCount = builder.scriptCount;
    }

    public static FieldTypes of(Function<Builder, ObjectBuilder<FieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final int count() {
        return this.count;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    @Nullable
    public final Long indexedVectorCount() {
        return this.indexedVectorCount;
    }

    @Nullable
    public final Long indexedVectorDimMax() {
        return this.indexedVectorDimMax;
    }

    @Nullable
    public final Long indexedVectorDimMin() {
        return this.indexedVectorDimMin;
    }

    @Nullable
    public final Integer scriptCount() {
        return this.scriptCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (this.indexedVectorCount != null) {
            generator.writeKey("indexed_vector_count");
            generator.write(this.indexedVectorCount.longValue());
        }
        if (this.indexedVectorDimMax != null) {
            generator.writeKey("indexed_vector_dim_max");
            generator.write(this.indexedVectorDimMax.longValue());
        }
        if (this.indexedVectorDimMin != null) {
            generator.writeKey("indexed_vector_dim_min");
            generator.write(this.indexedVectorDimMin.longValue());
        }
        if (this.scriptCount != null) {
            generator.writeKey("script_count");
            generator.write(this.scriptCount.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::indexedVectorCount, JsonpDeserializer.longDeserializer(), "indexed_vector_count");
        op.add(Builder::indexedVectorDimMax, JsonpDeserializer.longDeserializer(), "indexed_vector_dim_max");
        op.add(Builder::indexedVectorDimMin, JsonpDeserializer.longDeserializer(), "indexed_vector_dim_min");
        op.add(Builder::scriptCount, JsonpDeserializer.integerDeserializer(), "script_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        @Nullable
        private Long indexedVectorCount;
        @Nullable
        private Long indexedVectorDimMax;
        @Nullable
        private Long indexedVectorDimMin;
        @Nullable
        private Integer scriptCount;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder indexedVectorCount(@Nullable Long value) {
            this.indexedVectorCount = value;
            return this;
        }

        public final Builder indexedVectorDimMax(@Nullable Long value) {
            this.indexedVectorDimMax = value;
            return this;
        }

        public final Builder indexedVectorDimMin(@Nullable Long value) {
            this.indexedVectorDimMin = value;
            return this;
        }

        public final Builder scriptCount(@Nullable Integer value) {
            this.scriptCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldTypes build() {
            this._checkSingleUse();
            return new FieldTypes(this);
        }
    }
}

