/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IpFilter
implements JsonpSerializable {
    private final boolean http;
    private final boolean transport;
    public static final JsonpDeserializer<IpFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpFilter::setupIpFilterDeserializer);

    private IpFilter(Builder builder) {
        this.http = ApiTypeHelper.requireNonNull(builder.http, (Object)this, "http", false);
        this.transport = ApiTypeHelper.requireNonNull(builder.transport, (Object)this, "transport", false);
    }

    public static IpFilter of(Function<Builder, ObjectBuilder<IpFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean http() {
        return this.http;
    }

    public final boolean transport() {
        return this.transport;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("http");
        generator.write(this.http);
        generator.writeKey("transport");
        generator.write(this.transport);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIpFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::http, JsonpDeserializer.booleanDeserializer(), "http");
        op.add(Builder::transport, JsonpDeserializer.booleanDeserializer(), "transport");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IpFilter> {
        private Boolean http;
        private Boolean transport;

        public final Builder http(boolean value) {
            this.http = value;
            return this;
        }

        public final Builder transport(boolean value) {
            this.transport = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpFilter build() {
            this._checkSingleUse();
            return new IpFilter(this);
        }
    }
}

