/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.OverallBucket;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetOverallBucketsResponse
implements JsonpSerializable {
    private final long count;
    private final List<OverallBucket> overallBuckets;
    public static final JsonpDeserializer<GetOverallBucketsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetOverallBucketsResponse::setupGetOverallBucketsResponseDeserializer);

    private GetOverallBucketsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.overallBuckets = ApiTypeHelper.unmodifiableRequired(builder.overallBuckets, (Object)this, "overallBuckets");
    }

    public static GetOverallBucketsResponse of(Function<Builder, ObjectBuilder<GetOverallBucketsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<OverallBucket> overallBuckets() {
        return this.overallBuckets;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.overallBuckets)) {
            generator.writeKey("overall_buckets");
            generator.writeStartArray();
            for (OverallBucket item0 : this.overallBuckets) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetOverallBucketsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::overallBuckets, JsonpDeserializer.arrayDeserializer(OverallBucket._DESERIALIZER), "overall_buckets");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetOverallBucketsResponse> {
        private Long count;
        private List<OverallBucket> overallBuckets;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder overallBuckets(List<OverallBucket> list) {
            this.overallBuckets = Builder._listAddAll(this.overallBuckets, list);
            return this;
        }

        public final Builder overallBuckets(OverallBucket value, OverallBucket ... values) {
            this.overallBuckets = Builder._listAdd(this.overallBuckets, value, values);
            return this;
        }

        public final Builder overallBuckets(Function<OverallBucket.Builder, ObjectBuilder<OverallBucket>> fn) {
            return this.overallBuckets(fn.apply(new OverallBucket.Builder()).build(), new OverallBucket[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetOverallBucketsResponse build() {
            this._checkSingleUse();
            return new GetOverallBucketsResponse(this);
        }
    }
}

