/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InlineGet<TDocument>
implements JsonpSerializable {
    private final Map<String, JsonData> metadata;
    private final Map<String, JsonData> fields;
    private final boolean found;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String routing;
    @Nullable
    private final TDocument source;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<InlineGet<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> InlineGet.createInlineGetDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_types.InlineGet.TDocument")));

    private InlineGet(Builder<TDocument> builder) {
        this.metadata = ApiTypeHelper.unmodifiable(((Builder)builder).metadata);
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.found = ApiTypeHelper.requireNonNull(((Builder)builder).found, (Object)this, "found", false);
        this.seqNo = ((Builder)builder).seqNo;
        this.primaryTerm = ((Builder)builder).primaryTerm;
        this.routing = ((Builder)builder).routing;
        this.source = ((Builder)builder).source;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> InlineGet<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<InlineGet<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    public final boolean found() {
        return this.found;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final TDocument source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("found");
        generator.write(this.found);
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument> JsonpDeserializer<InlineGet<TDocument>> createInlineGetDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> InlineGet.setupInlineGetDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupInlineGetDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::source, tDocumentDeserializer, "_source");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.metadata((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<InlineGet<TDocument>> {
        @Nullable
        private Map<String, JsonData> metadata = new HashMap<String, JsonData>();
        @Nullable
        private Map<String, JsonData> fields;
        private Boolean found;
        @Nullable
        private Long seqNo;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String routing;
        @Nullable
        private TDocument source;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder<TDocument> metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TDocument> found(boolean value) {
            this.found = value;
            return this;
        }

        public final Builder<TDocument> seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this;
        }

        public final Builder<TDocument> primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public InlineGet<TDocument> build() {
            this._checkSingleUse();
            return new InlineGet(this);
        }
    }
}

