/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.query_role;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleQuery
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<RoleQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleQuery::setupRoleQueryDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public RoleQuery(RoleQueryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._roleQueryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private RoleQuery(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static RoleQuery of(Function<Builder, ObjectBuilder<RoleQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isBool() {
        return this._kind == Kind.Bool;
    }

    public BoolQuery bool() {
        return (BoolQuery)TaggedUnionUtils.get(this, Kind.Bool);
    }

    public boolean isExists() {
        return this._kind == Kind.Exists;
    }

    public ExistsQuery exists() {
        return (ExistsQuery)TaggedUnionUtils.get(this, Kind.Exists);
    }

    public boolean isIds() {
        return this._kind == Kind.Ids;
    }

    public IdsQuery ids() {
        return (IdsQuery)TaggedUnionUtils.get(this, Kind.Ids);
    }

    public boolean isMatch() {
        return this._kind == Kind.Match;
    }

    public MatchQuery match() {
        return (MatchQuery)TaggedUnionUtils.get(this, Kind.Match);
    }

    public boolean isMatchAll() {
        return this._kind == Kind.MatchAll;
    }

    public MatchAllQuery matchAll() {
        return (MatchAllQuery)TaggedUnionUtils.get(this, Kind.MatchAll);
    }

    public boolean isPrefix() {
        return this._kind == Kind.Prefix;
    }

    public PrefixQuery prefix() {
        return (PrefixQuery)TaggedUnionUtils.get(this, Kind.Prefix);
    }

    public boolean isRange() {
        return this._kind == Kind.Range;
    }

    public RangeQuery range() {
        return (RangeQuery)TaggedUnionUtils.get(this, Kind.Range);
    }

    public boolean isSimpleQueryString() {
        return this._kind == Kind.SimpleQueryString;
    }

    public SimpleQueryStringQuery simpleQueryString() {
        return (SimpleQueryStringQuery)TaggedUnionUtils.get(this, Kind.SimpleQueryString);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermQuery term() {
        return (TermQuery)TaggedUnionUtils.get(this, Kind.Term);
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public TermsQuery terms() {
        return (TermsQuery)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isWildcard() {
        return this._kind == Kind.Wildcard;
    }

    public WildcardQuery wildcard() {
        return (WildcardQuery)TaggedUnionUtils.get(this, Kind.Wildcard);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRoleQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bool, BoolQuery._DESERIALIZER, "bool");
        op.add(Builder::exists, ExistsQuery._DESERIALIZER, "exists");
        op.add(Builder::ids, IdsQuery._DESERIALIZER, "ids");
        op.add(Builder::match, MatchQuery._DESERIALIZER, "match");
        op.add(Builder::matchAll, MatchAllQuery._DESERIALIZER, "match_all");
        op.add(Builder::prefix, PrefixQuery._DESERIALIZER, "prefix");
        op.add(Builder::range, RangeQuery._DESERIALIZER, "range");
        op.add(Builder::simpleQueryString, SimpleQueryStringQuery._DESERIALIZER, "simple_query_string");
        op.add(Builder::term, TermQuery._DESERIALIZER, "term");
        op.add(Builder::terms, TermsQuery._DESERIALIZER, "terms");
        op.add(Builder::wildcard, WildcardQuery._DESERIALIZER, "wildcard");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleQuery> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<RoleQuery> bool(BoolQuery v) {
            this._kind = Kind.Bool;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> bool(Function<BoolQuery.Builder, ObjectBuilder<BoolQuery>> fn) {
            return this.bool(fn.apply(new BoolQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> exists(ExistsQuery v) {
            this._kind = Kind.Exists;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> exists(Function<ExistsQuery.Builder, ObjectBuilder<ExistsQuery>> fn) {
            return this.exists(fn.apply(new ExistsQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> ids(IdsQuery v) {
            this._kind = Kind.Ids;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> ids(Function<IdsQuery.Builder, ObjectBuilder<IdsQuery>> fn) {
            return this.ids(fn.apply(new IdsQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> match(MatchQuery v) {
            this._kind = Kind.Match;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> match(Function<MatchQuery.Builder, ObjectBuilder<MatchQuery>> fn) {
            return this.match(fn.apply(new MatchQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> matchAll(MatchAllQuery v) {
            this._kind = Kind.MatchAll;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> matchAll(Function<MatchAllQuery.Builder, ObjectBuilder<MatchAllQuery>> fn) {
            return this.matchAll(fn.apply(new MatchAllQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> prefix(PrefixQuery v) {
            this._kind = Kind.Prefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> prefix(Function<PrefixQuery.Builder, ObjectBuilder<PrefixQuery>> fn) {
            return this.prefix(fn.apply(new PrefixQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> range(RangeQuery v) {
            this._kind = Kind.Range;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> range(Function<RangeQuery.Builder, ObjectBuilder<RangeQuery>> fn) {
            return this.range(fn.apply(new RangeQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> simpleQueryString(SimpleQueryStringQuery v) {
            this._kind = Kind.SimpleQueryString;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> simpleQueryString(Function<SimpleQueryStringQuery.Builder, ObjectBuilder<SimpleQueryStringQuery>> fn) {
            return this.simpleQueryString(fn.apply(new SimpleQueryStringQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> term(TermQuery v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> term(Function<TermQuery.Builder, ObjectBuilder<TermQuery>> fn) {
            return this.term(fn.apply(new TermQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> terms(TermsQuery v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> terms(Function<TermsQuery.Builder, ObjectBuilder<TermsQuery>> fn) {
            return this.terms(fn.apply(new TermsQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> wildcard(WildcardQuery v) {
            this._kind = Kind.Wildcard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleQuery> wildcard(Function<WildcardQuery.Builder, ObjectBuilder<WildcardQuery>> fn) {
            return this.wildcard(fn.apply(new WildcardQuery.Builder()).build());
        }

        public ObjectBuilder<RoleQuery> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public RoleQuery build() {
            this._checkSingleUse();
            return new RoleQuery(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Bool("bool"),
        Exists("exists"),
        Ids("ids"),
        Match("match"),
        MatchAll("match_all"),
        Prefix("prefix"),
        Range("range"),
        SimpleQueryString("simple_query_string"),
        Term("term"),
        Terms("terms"),
        Wildcard("wildcard"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

