/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DiscoveryNodeContent;
import co.elastic.clients.elasticsearch.ml.TrainedModelAssignmentRoutingTable;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelDeploymentNodesStats
implements JsonpSerializable {
    @Nullable
    private final Double averageInferenceTimeMs;
    @Nullable
    private final Double averageInferenceTimeMsLastMinute;
    @Nullable
    private final Double averageInferenceTimeMsExcludingCacheHits;
    @Nullable
    private final Integer errorCount;
    @Nullable
    private final Long inferenceCount;
    @Nullable
    private final Long inferenceCacheHitCount;
    @Nullable
    private final Long inferenceCacheHitCountLastMinute;
    @Nullable
    private final Long lastAccess;
    @Nullable
    private final DiscoveryNodeContent node;
    @Nullable
    private final Integer numberOfAllocations;
    @Nullable
    private final Integer numberOfPendingRequests;
    private final long peakThroughputPerMinute;
    @Nullable
    private final Integer rejectionExecutionCount;
    private final TrainedModelAssignmentRoutingTable routingState;
    @Nullable
    private final Long startTime;
    @Nullable
    private final Integer threadsPerAllocation;
    private final int throughputLastMinute;
    @Nullable
    private final Integer timeoutCount;
    public static final JsonpDeserializer<TrainedModelDeploymentNodesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentNodesStats::setupTrainedModelDeploymentNodesStatsDeserializer);

    private TrainedModelDeploymentNodesStats(Builder builder) {
        this.averageInferenceTimeMs = builder.averageInferenceTimeMs;
        this.averageInferenceTimeMsLastMinute = builder.averageInferenceTimeMsLastMinute;
        this.averageInferenceTimeMsExcludingCacheHits = builder.averageInferenceTimeMsExcludingCacheHits;
        this.errorCount = builder.errorCount;
        this.inferenceCount = builder.inferenceCount;
        this.inferenceCacheHitCount = builder.inferenceCacheHitCount;
        this.inferenceCacheHitCountLastMinute = builder.inferenceCacheHitCountLastMinute;
        this.lastAccess = builder.lastAccess;
        this.node = builder.node;
        this.numberOfAllocations = builder.numberOfAllocations;
        this.numberOfPendingRequests = builder.numberOfPendingRequests;
        this.peakThroughputPerMinute = ApiTypeHelper.requireNonNull(builder.peakThroughputPerMinute, this, "peakThroughputPerMinute");
        this.rejectionExecutionCount = builder.rejectionExecutionCount;
        this.routingState = ApiTypeHelper.requireNonNull(builder.routingState, this, "routingState");
        this.startTime = builder.startTime;
        this.threadsPerAllocation = builder.threadsPerAllocation;
        this.throughputLastMinute = ApiTypeHelper.requireNonNull(builder.throughputLastMinute, this, "throughputLastMinute");
        this.timeoutCount = builder.timeoutCount;
    }

    public static TrainedModelDeploymentNodesStats of(Function<Builder, ObjectBuilder<TrainedModelDeploymentNodesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double averageInferenceTimeMs() {
        return this.averageInferenceTimeMs;
    }

    @Nullable
    public final Double averageInferenceTimeMsLastMinute() {
        return this.averageInferenceTimeMsLastMinute;
    }

    @Nullable
    public final Double averageInferenceTimeMsExcludingCacheHits() {
        return this.averageInferenceTimeMsExcludingCacheHits;
    }

    @Nullable
    public final Integer errorCount() {
        return this.errorCount;
    }

    @Nullable
    public final Long inferenceCount() {
        return this.inferenceCount;
    }

    @Nullable
    public final Long inferenceCacheHitCount() {
        return this.inferenceCacheHitCount;
    }

    @Nullable
    public final Long inferenceCacheHitCountLastMinute() {
        return this.inferenceCacheHitCountLastMinute;
    }

    @Nullable
    public final Long lastAccess() {
        return this.lastAccess;
    }

    @Nullable
    public final DiscoveryNodeContent node() {
        return this.node;
    }

    @Nullable
    public final Integer numberOfAllocations() {
        return this.numberOfAllocations;
    }

    @Nullable
    public final Integer numberOfPendingRequests() {
        return this.numberOfPendingRequests;
    }

    public final long peakThroughputPerMinute() {
        return this.peakThroughputPerMinute;
    }

    @Nullable
    public final Integer rejectionExecutionCount() {
        return this.rejectionExecutionCount;
    }

    public final TrainedModelAssignmentRoutingTable routingState() {
        return this.routingState;
    }

    @Nullable
    public final Long startTime() {
        return this.startTime;
    }

    @Nullable
    public final Integer threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    public final int throughputLastMinute() {
        return this.throughputLastMinute;
    }

    @Nullable
    public final Integer timeoutCount() {
        return this.timeoutCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.averageInferenceTimeMs != null) {
            generator.writeKey("average_inference_time_ms");
            generator.write(this.averageInferenceTimeMs.doubleValue());
        }
        if (this.averageInferenceTimeMsLastMinute != null) {
            generator.writeKey("average_inference_time_ms_last_minute");
            generator.write(this.averageInferenceTimeMsLastMinute.doubleValue());
        }
        if (this.averageInferenceTimeMsExcludingCacheHits != null) {
            generator.writeKey("average_inference_time_ms_excluding_cache_hits");
            generator.write(this.averageInferenceTimeMsExcludingCacheHits.doubleValue());
        }
        if (this.errorCount != null) {
            generator.writeKey("error_count");
            generator.write(this.errorCount.intValue());
        }
        if (this.inferenceCount != null) {
            generator.writeKey("inference_count");
            generator.write(this.inferenceCount.longValue());
        }
        if (this.inferenceCacheHitCount != null) {
            generator.writeKey("inference_cache_hit_count");
            generator.write(this.inferenceCacheHitCount.longValue());
        }
        if (this.inferenceCacheHitCountLastMinute != null) {
            generator.writeKey("inference_cache_hit_count_last_minute");
            generator.write(this.inferenceCacheHitCountLastMinute.longValue());
        }
        if (this.lastAccess != null) {
            generator.writeKey("last_access");
            generator.write(this.lastAccess.longValue());
        }
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        if (this.numberOfAllocations != null) {
            generator.writeKey("number_of_allocations");
            generator.write(this.numberOfAllocations.intValue());
        }
        if (this.numberOfPendingRequests != null) {
            generator.writeKey("number_of_pending_requests");
            generator.write(this.numberOfPendingRequests.intValue());
        }
        generator.writeKey("peak_throughput_per_minute");
        generator.write(this.peakThroughputPerMinute);
        if (this.rejectionExecutionCount != null) {
            generator.writeKey("rejection_execution_count");
            generator.write(this.rejectionExecutionCount.intValue());
        }
        generator.writeKey("routing_state");
        this.routingState.serialize(generator, mapper);
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime.longValue());
        }
        if (this.threadsPerAllocation != null) {
            generator.writeKey("threads_per_allocation");
            generator.write(this.threadsPerAllocation.intValue());
        }
        generator.writeKey("throughput_last_minute");
        generator.write(this.throughputLastMinute);
        if (this.timeoutCount != null) {
            generator.writeKey("timeout_count");
            generator.write(this.timeoutCount.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelDeploymentNodesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::averageInferenceTimeMs, JsonpDeserializer.doubleDeserializer(), "average_inference_time_ms");
        op.add(Builder::averageInferenceTimeMsLastMinute, JsonpDeserializer.doubleDeserializer(), "average_inference_time_ms_last_minute");
        op.add(Builder::averageInferenceTimeMsExcludingCacheHits, JsonpDeserializer.doubleDeserializer(), "average_inference_time_ms_excluding_cache_hits");
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.longDeserializer(), "inference_count");
        op.add(Builder::inferenceCacheHitCount, JsonpDeserializer.longDeserializer(), "inference_cache_hit_count");
        op.add(Builder::inferenceCacheHitCountLastMinute, JsonpDeserializer.longDeserializer(), "inference_cache_hit_count_last_minute");
        op.add(Builder::lastAccess, JsonpDeserializer.longDeserializer(), "last_access");
        op.add(Builder::node, DiscoveryNodeContent._DESERIALIZER, "node");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::numberOfPendingRequests, JsonpDeserializer.integerDeserializer(), "number_of_pending_requests");
        op.add(Builder::peakThroughputPerMinute, JsonpDeserializer.longDeserializer(), "peak_throughput_per_minute");
        op.add(Builder::rejectionExecutionCount, JsonpDeserializer.integerDeserializer(), "rejection_execution_count");
        op.add(Builder::routingState, TrainedModelAssignmentRoutingTable._DESERIALIZER, "routing_state");
        op.add(Builder::startTime, JsonpDeserializer.longDeserializer(), "start_time");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
        op.add(Builder::throughputLastMinute, JsonpDeserializer.integerDeserializer(), "throughput_last_minute");
        op.add(Builder::timeoutCount, JsonpDeserializer.integerDeserializer(), "timeout_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentNodesStats> {
        @Nullable
        private Double averageInferenceTimeMs;
        @Nullable
        private Double averageInferenceTimeMsLastMinute;
        @Nullable
        private Double averageInferenceTimeMsExcludingCacheHits;
        @Nullable
        private Integer errorCount;
        @Nullable
        private Long inferenceCount;
        @Nullable
        private Long inferenceCacheHitCount;
        @Nullable
        private Long inferenceCacheHitCountLastMinute;
        @Nullable
        private Long lastAccess;
        @Nullable
        private DiscoveryNodeContent node;
        @Nullable
        private Integer numberOfAllocations;
        @Nullable
        private Integer numberOfPendingRequests;
        private Long peakThroughputPerMinute;
        @Nullable
        private Integer rejectionExecutionCount;
        private TrainedModelAssignmentRoutingTable routingState;
        @Nullable
        private Long startTime;
        @Nullable
        private Integer threadsPerAllocation;
        private Integer throughputLastMinute;
        @Nullable
        private Integer timeoutCount;

        public final Builder averageInferenceTimeMs(@Nullable Double value) {
            this.averageInferenceTimeMs = value;
            return this;
        }

        public final Builder averageInferenceTimeMsLastMinute(@Nullable Double value) {
            this.averageInferenceTimeMsLastMinute = value;
            return this;
        }

        public final Builder averageInferenceTimeMsExcludingCacheHits(@Nullable Double value) {
            this.averageInferenceTimeMsExcludingCacheHits = value;
            return this;
        }

        public final Builder errorCount(@Nullable Integer value) {
            this.errorCount = value;
            return this;
        }

        public final Builder inferenceCount(@Nullable Long value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder inferenceCacheHitCount(@Nullable Long value) {
            this.inferenceCacheHitCount = value;
            return this;
        }

        public final Builder inferenceCacheHitCountLastMinute(@Nullable Long value) {
            this.inferenceCacheHitCountLastMinute = value;
            return this;
        }

        public final Builder lastAccess(@Nullable Long value) {
            this.lastAccess = value;
            return this;
        }

        public final Builder node(@Nullable DiscoveryNodeContent value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNodeContent.Builder, ObjectBuilder<DiscoveryNodeContent>> fn) {
            return this.node(fn.apply(new DiscoveryNodeContent.Builder()).build());
        }

        public final Builder numberOfAllocations(@Nullable Integer value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder numberOfPendingRequests(@Nullable Integer value) {
            this.numberOfPendingRequests = value;
            return this;
        }

        public final Builder peakThroughputPerMinute(long value) {
            this.peakThroughputPerMinute = value;
            return this;
        }

        public final Builder rejectionExecutionCount(@Nullable Integer value) {
            this.rejectionExecutionCount = value;
            return this;
        }

        public final Builder routingState(TrainedModelAssignmentRoutingTable value) {
            this.routingState = value;
            return this;
        }

        public final Builder routingState(Function<TrainedModelAssignmentRoutingTable.Builder, ObjectBuilder<TrainedModelAssignmentRoutingTable>> fn) {
            return this.routingState(fn.apply(new TrainedModelAssignmentRoutingTable.Builder()).build());
        }

        public final Builder startTime(@Nullable Long value) {
            this.startTime = value;
            return this;
        }

        public final Builder threadsPerAllocation(@Nullable Integer value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder throughputLastMinute(int value) {
            this.throughputLastMinute = value;
            return this;
        }

        public final Builder timeoutCount(@Nullable Integer value) {
            this.timeoutCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentNodesStats build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentNodesStats(this);
        }
    }
}

