/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RandomSamplerAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    private final double probability;
    @Nullable
    private final Integer seed;
    @Nullable
    private final Integer shardSeed;
    public static final JsonpDeserializer<RandomSamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RandomSamplerAggregation::setupRandomSamplerAggregationDeserializer);

    private RandomSamplerAggregation(Builder builder) {
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, this, "probability");
        this.seed = builder.seed;
        this.shardSeed = builder.shardSeed;
    }

    public static RandomSamplerAggregation of(Function<Builder, ObjectBuilder<RandomSamplerAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.RandomSampler;
    }

    public final double probability() {
        return this.probability;
    }

    @Nullable
    public final Integer seed() {
        return this.seed;
    }

    @Nullable
    public final Integer shardSeed() {
        return this.shardSeed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("probability");
        generator.write(this.probability);
        if (this.seed != null) {
            generator.writeKey("seed");
            generator.write(this.seed.intValue());
        }
        if (this.shardSeed != null) {
            generator.writeKey("shard_seed");
            generator.write(this.shardSeed.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRandomSamplerAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::seed, JsonpDeserializer.integerDeserializer(), "seed");
        op.add(Builder::shardSeed, JsonpDeserializer.integerDeserializer(), "shard_seed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RandomSamplerAggregation> {
        private Double probability;
        @Nullable
        private Integer seed;
        @Nullable
        private Integer shardSeed;

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder seed(@Nullable Integer value) {
            this.seed = value;
            return this;
        }

        public final Builder shardSeed(@Nullable Integer value) {
            this.shardSeed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RandomSamplerAggregation build() {
            this._checkSingleUse();
            return new RandomSamplerAggregation(this);
        }
    }
}

