/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.OidcLogoutResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OidcLogoutRequest
extends RequestBase
implements JsonpSerializable {
    private final String accessToken;
    @Nullable
    private final String refreshToken;
    public static final JsonpDeserializer<OidcLogoutRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OidcLogoutRequest::setupOidcLogoutRequestDeserializer);
    public static final Endpoint<OidcLogoutRequest, OidcLogoutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<OidcLogoutRequest, OidcLogoutResponse>("es/security.oidc_logout", request -> "POST", request -> "/_security/oidc/logout", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, OidcLogoutResponse._DESERIALIZER);

    private OidcLogoutRequest(Builder builder) {
        this.accessToken = ApiTypeHelper.requireNonNull(builder.accessToken, this, "accessToken");
        this.refreshToken = builder.refreshToken;
    }

    public static OidcLogoutRequest of(Function<Builder, ObjectBuilder<OidcLogoutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessToken() {
        return this.accessToken;
    }

    @Nullable
    public final String refreshToken() {
        return this.refreshToken;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
    }

    protected static void setupOidcLogoutRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<OidcLogoutRequest> {
        private String accessToken;
        @Nullable
        private String refreshToken;

        public final Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OidcLogoutRequest build() {
            this._checkSingleUse();
            return new OidcLogoutRequest(this);
        }
    }
}

