/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.NodesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class NodesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean fullId;
    @Nullable
    private final Boolean includeUnloadedSegments;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<NodesRequest, NodesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesRequest, NodesResponse>("es/cat.nodes", request -> "GET", request -> "/_cat/nodes", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.fullId != null) {
            params.put("full_id", String.valueOf(request.fullId));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesResponse._DESERIALIZER);

    private NodesRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.fullId = builder.fullId;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.masterTimeout = builder.masterTimeout;
        this.time = builder.time;
    }

    public static NodesRequest of(Function<Builder, ObjectBuilder<NodesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Boolean fullId() {
        return this.fullId;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NodesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean fullId;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private TimeUnit time;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder fullId(@Nullable Boolean value) {
            this.fullId = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesRequest build() {
            this._checkSingleUse();
            return new NodesRequest(this);
        }
    }
}

