/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.BucketSummary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetBucketsResponse
implements JsonpSerializable {
    private final List<BucketSummary> buckets;
    private final long count;
    public static final JsonpDeserializer<GetBucketsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetBucketsResponse::setupGetBucketsResponseDeserializer);

    private GetBucketsResponse(Builder builder) {
        this.buckets = ApiTypeHelper.unmodifiableRequired(builder.buckets, (Object)this, "buckets");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
    }

    public static GetBucketsResponse of(Function<Builder, ObjectBuilder<GetBucketsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<BucketSummary> buckets() {
        return this.buckets;
    }

    public final long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.buckets)) {
            generator.writeKey("buckets");
            generator.writeStartArray();
            for (BucketSummary item0 : this.buckets) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("count");
        generator.write(this.count);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetBucketsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buckets, JsonpDeserializer.arrayDeserializer(BucketSummary._DESERIALIZER), "buckets");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetBucketsResponse> {
        private List<BucketSummary> buckets;
        private Long count;

        public final Builder buckets(List<BucketSummary> list) {
            this.buckets = Builder._listAddAll(this.buckets, list);
            return this;
        }

        public final Builder buckets(BucketSummary value, BucketSummary ... values) {
            this.buckets = Builder._listAdd(this.buckets, value, values);
            return this;
        }

        public final Builder buckets(Function<BucketSummary.Builder, ObjectBuilder<BucketSummary>> fn) {
            return this.buckets(fn.apply(new BucketSummary.Builder()).build(), new BucketSummary[0]);
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetBucketsResponse build() {
            this._checkSingleUse();
            return new GetBucketsResponse(this);
        }
    }
}

