/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.OverallBucketJob;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OverallBucket
implements JsonpSerializable {
    private final long bucketSpan;
    private final boolean isInterim;
    private final List<OverallBucketJob> jobs;
    private final double overallScore;
    private final String resultType;
    private final long timestamp;
    @Nullable
    private final DateTime timestampString;
    public static final JsonpDeserializer<OverallBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverallBucket::setupOverallBucketDeserializer);

    private OverallBucket(Builder builder) {
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, this, "bucketSpan");
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, this, "isInterim");
        this.jobs = ApiTypeHelper.unmodifiableRequired(builder.jobs, (Object)this, "jobs");
        this.overallScore = ApiTypeHelper.requireNonNull(builder.overallScore, this, "overallScore");
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.timestampString = builder.timestampString;
    }

    public static OverallBucket of(Function<Builder, ObjectBuilder<OverallBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bucketSpan() {
        return this.bucketSpan;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final List<OverallBucketJob> jobs() {
        return this.jobs;
    }

    public final double overallScore() {
        return this.overallScore;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final DateTime timestampString() {
        return this.timestampString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        if (ApiTypeHelper.isDefined(this.jobs)) {
            generator.writeKey("jobs");
            generator.writeStartArray();
            for (OverallBucketJob item0 : this.jobs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("overall_score");
        generator.write(this.overallScore);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.timestampString != null) {
            generator.writeKey("timestamp_string");
            this.timestampString.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOverallBucketDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(OverallBucketJob._DESERIALIZER), "jobs");
        op.add(Builder::overallScore, JsonpDeserializer.doubleDeserializer(), "overall_score");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::timestampString, DateTime._DESERIALIZER, "timestamp_string");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OverallBucket> {
        private Long bucketSpan;
        private Boolean isInterim;
        private List<OverallBucketJob> jobs;
        private Double overallScore;
        private String resultType;
        private Long timestamp;
        @Nullable
        private DateTime timestampString;

        public final Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobs(List<OverallBucketJob> list) {
            this.jobs = Builder._listAddAll(this.jobs, list);
            return this;
        }

        public final Builder jobs(OverallBucketJob value, OverallBucketJob ... values) {
            this.jobs = Builder._listAdd(this.jobs, value, values);
            return this;
        }

        public final Builder jobs(Function<OverallBucketJob.Builder, ObjectBuilder<OverallBucketJob>> fn) {
            return this.jobs(fn.apply(new OverallBucketJob.Builder()).build(), new OverallBucketJob[0]);
        }

        public final Builder overallScore(double value) {
            this.overallScore = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestampString(@Nullable DateTime value) {
            this.timestampString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OverallBucket build() {
            this._checkSingleUse();
            return new OverallBucket(this);
        }
    }
}

