/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.DataStreamIndex;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FailureStore
implements JsonpSerializable {
    private final boolean enabled;
    private final List<DataStreamIndex> indices;
    private final boolean rolloverOnWrite;
    public static final JsonpDeserializer<FailureStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FailureStore::setupFailureStoreDeserializer);

    private FailureStore(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.rolloverOnWrite = ApiTypeHelper.requireNonNull(builder.rolloverOnWrite, this, "rolloverOnWrite");
    }

    public static FailureStore of(Function<Builder, ObjectBuilder<FailureStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final List<DataStreamIndex> indices() {
        return this.indices;
    }

    public final boolean rolloverOnWrite() {
        return this.rolloverOnWrite;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (DataStreamIndex item0 : this.indices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("rollover_on_write");
        generator.write(this.rolloverOnWrite);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFailureStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(DataStreamIndex._DESERIALIZER), "indices");
        op.add(Builder::rolloverOnWrite, JsonpDeserializer.booleanDeserializer(), "rollover_on_write");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FailureStore> {
        private Boolean enabled;
        private List<DataStreamIndex> indices;
        private Boolean rolloverOnWrite;

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder indices(List<DataStreamIndex> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(DataStreamIndex value, DataStreamIndex ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<DataStreamIndex.Builder, ObjectBuilder<DataStreamIndex>> fn) {
            return this.indices(fn.apply(new DataStreamIndex.Builder()).build(), new DataStreamIndex[0]);
        }

        public final Builder rolloverOnWrite(boolean value) {
            this.rolloverOnWrite = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FailureStore build() {
            this._checkSingleUse();
            return new FailureStore(this);
        }
    }
}

