/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.indices.DataStreamIndex;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleWithRollover;
import co.elastic.clients.elasticsearch.indices.DataStreamTimestampField;
import co.elastic.clients.elasticsearch.indices.FailureStore;
import co.elastic.clients.elasticsearch.indices.ManagedBy;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStream
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowCustomRouting;
    @Nullable
    private final FailureStore failureStore;
    private final int generation;
    private final boolean hidden;
    @Nullable
    private final String ilmPolicy;
    private final ManagedBy nextGenerationManagedBy;
    private final boolean preferIlm;
    private final List<DataStreamIndex> indices;
    @Nullable
    private final DataStreamLifecycleWithRollover lifecycle;
    private final String name;
    @Nullable
    private final Boolean replicated;
    private final boolean rolloverOnWrite;
    private final HealthStatus status;
    @Nullable
    private final Boolean system;
    private final String template;
    private final DataStreamTimestampField timestampField;
    public static final JsonpDeserializer<DataStream> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStream::setupDataStreamDeserializer);

    private DataStream(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.allowCustomRouting = builder.allowCustomRouting;
        this.failureStore = builder.failureStore;
        this.generation = ApiTypeHelper.requireNonNull(builder.generation, this, "generation");
        this.hidden = ApiTypeHelper.requireNonNull(builder.hidden, this, "hidden");
        this.ilmPolicy = builder.ilmPolicy;
        this.nextGenerationManagedBy = ApiTypeHelper.requireNonNull(builder.nextGenerationManagedBy, this, "nextGenerationManagedBy");
        this.preferIlm = ApiTypeHelper.requireNonNull(builder.preferIlm, this, "preferIlm");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.lifecycle = builder.lifecycle;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.replicated = builder.replicated;
        this.rolloverOnWrite = ApiTypeHelper.requireNonNull(builder.rolloverOnWrite, this, "rolloverOnWrite");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.system = builder.system;
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.timestampField = ApiTypeHelper.requireNonNull(builder.timestampField, this, "timestampField");
    }

    public static DataStream of(Function<Builder, ObjectBuilder<DataStream>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean allowCustomRouting() {
        return this.allowCustomRouting;
    }

    @Nullable
    public final FailureStore failureStore() {
        return this.failureStore;
    }

    public final int generation() {
        return this.generation;
    }

    public final boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final String ilmPolicy() {
        return this.ilmPolicy;
    }

    public final ManagedBy nextGenerationManagedBy() {
        return this.nextGenerationManagedBy;
    }

    public final boolean preferIlm() {
        return this.preferIlm;
    }

    public final List<DataStreamIndex> indices() {
        return this.indices;
    }

    @Nullable
    public final DataStreamLifecycleWithRollover lifecycle() {
        return this.lifecycle;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Boolean replicated() {
        return this.replicated;
    }

    public final boolean rolloverOnWrite() {
        return this.rolloverOnWrite;
    }

    public final HealthStatus status() {
        return this.status;
    }

    @Nullable
    public final Boolean system() {
        return this.system;
    }

    public final String template() {
        return this.template;
    }

    public final DataStreamTimestampField timestampField() {
        return this.timestampField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowCustomRouting != null) {
            generator.writeKey("allow_custom_routing");
            generator.write(this.allowCustomRouting.booleanValue());
        }
        if (this.failureStore != null) {
            generator.writeKey("failure_store");
            this.failureStore.serialize(generator, mapper);
        }
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("hidden");
        generator.write(this.hidden);
        if (this.ilmPolicy != null) {
            generator.writeKey("ilm_policy");
            generator.write(this.ilmPolicy);
        }
        generator.writeKey("next_generation_managed_by");
        this.nextGenerationManagedBy.serialize(generator, mapper);
        generator.writeKey("prefer_ilm");
        generator.write(this.preferIlm);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (DataStreamIndex dataStreamIndex : this.indices) {
                dataStreamIndex.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lifecycle != null) {
            generator.writeKey("lifecycle");
            this.lifecycle.serialize(generator, mapper);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.replicated != null) {
            generator.writeKey("replicated");
            generator.write(this.replicated.booleanValue());
        }
        generator.writeKey("rollover_on_write");
        generator.write(this.rolloverOnWrite);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.system != null) {
            generator.writeKey("system");
            generator.write(this.system.booleanValue());
        }
        generator.writeKey("template");
        generator.write(this.template);
        generator.writeKey("timestamp_field");
        this.timestampField.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::allowCustomRouting, JsonpDeserializer.booleanDeserializer(), "allow_custom_routing");
        op.add(Builder::failureStore, FailureStore._DESERIALIZER, "failure_store");
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::ilmPolicy, JsonpDeserializer.stringDeserializer(), "ilm_policy");
        op.add(Builder::nextGenerationManagedBy, ManagedBy._DESERIALIZER, "next_generation_managed_by");
        op.add(Builder::preferIlm, JsonpDeserializer.booleanDeserializer(), "prefer_ilm");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(DataStreamIndex._DESERIALIZER), "indices");
        op.add(Builder::lifecycle, DataStreamLifecycleWithRollover._DESERIALIZER, "lifecycle");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::replicated, JsonpDeserializer.booleanDeserializer(), "replicated");
        op.add(Builder::rolloverOnWrite, JsonpDeserializer.booleanDeserializer(), "rollover_on_write");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::system, JsonpDeserializer.booleanDeserializer(), "system");
        op.add(Builder::template, JsonpDeserializer.stringDeserializer(), "template");
        op.add(Builder::timestampField, DataStreamTimestampField._DESERIALIZER, "timestamp_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStream> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowCustomRouting;
        @Nullable
        private FailureStore failureStore;
        private Integer generation;
        private Boolean hidden;
        @Nullable
        private String ilmPolicy;
        private ManagedBy nextGenerationManagedBy;
        private Boolean preferIlm;
        private List<DataStreamIndex> indices;
        @Nullable
        private DataStreamLifecycleWithRollover lifecycle;
        private String name;
        @Nullable
        private Boolean replicated;
        private Boolean rolloverOnWrite;
        private HealthStatus status;
        @Nullable
        private Boolean system;
        private String template;
        private DataStreamTimestampField timestampField;

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder allowCustomRouting(@Nullable Boolean value) {
            this.allowCustomRouting = value;
            return this;
        }

        public final Builder failureStore(@Nullable FailureStore value) {
            this.failureStore = value;
            return this;
        }

        public final Builder failureStore(Function<FailureStore.Builder, ObjectBuilder<FailureStore>> fn) {
            return this.failureStore(fn.apply(new FailureStore.Builder()).build());
        }

        public final Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public final Builder hidden(boolean value) {
            this.hidden = value;
            return this;
        }

        public final Builder ilmPolicy(@Nullable String value) {
            this.ilmPolicy = value;
            return this;
        }

        public final Builder nextGenerationManagedBy(ManagedBy value) {
            this.nextGenerationManagedBy = value;
            return this;
        }

        public final Builder preferIlm(boolean value) {
            this.preferIlm = value;
            return this;
        }

        public final Builder indices(List<DataStreamIndex> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(DataStreamIndex value, DataStreamIndex ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<DataStreamIndex.Builder, ObjectBuilder<DataStreamIndex>> fn) {
            return this.indices(fn.apply(new DataStreamIndex.Builder()).build(), new DataStreamIndex[0]);
        }

        public final Builder lifecycle(@Nullable DataStreamLifecycleWithRollover value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<DataStreamLifecycleWithRollover.Builder, ObjectBuilder<DataStreamLifecycleWithRollover>> fn) {
            return this.lifecycle(fn.apply(new DataStreamLifecycleWithRollover.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder replicated(@Nullable Boolean value) {
            this.replicated = value;
            return this;
        }

        public final Builder rolloverOnWrite(boolean value) {
            this.rolloverOnWrite = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder system(@Nullable Boolean value) {
            this.system = value;
            return this;
        }

        public final Builder template(String value) {
            this.template = value;
            return this;
        }

        public final Builder timestampField(DataStreamTimestampField value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampField(Function<DataStreamTimestampField.Builder, ObjectBuilder<DataStreamTimestampField>> fn) {
            return this.timestampField(fn.apply(new DataStreamTimestampField.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStream build() {
            this._checkSingleUse();
            return new DataStream(this);
        }
    }
}

