/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityExecutionMode;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CardinalityAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer precisionThreshold;
    @Nullable
    private final Boolean rehash;
    @Nullable
    private final CardinalityExecutionMode executionHint;
    public static final JsonpDeserializer<CardinalityAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CardinalityAggregation::setupCardinalityAggregationDeserializer);

    private CardinalityAggregation(Builder builder) {
        super(builder);
        this.precisionThreshold = builder.precisionThreshold;
        this.rehash = builder.rehash;
        this.executionHint = builder.executionHint;
    }

    public static CardinalityAggregation of(Function<Builder, ObjectBuilder<CardinalityAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Cardinality;
    }

    @Nullable
    public final Integer precisionThreshold() {
        return this.precisionThreshold;
    }

    @Nullable
    public final Boolean rehash() {
        return this.rehash;
    }

    @Nullable
    public final CardinalityExecutionMode executionHint() {
        return this.executionHint;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.precisionThreshold != null) {
            generator.writeKey("precision_threshold");
            generator.write(this.precisionThreshold.intValue());
        }
        if (this.rehash != null) {
            generator.writeKey("rehash");
            generator.write(this.rehash.booleanValue());
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
    }

    protected static void setupCardinalityAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::precisionThreshold, JsonpDeserializer.integerDeserializer(), "precision_threshold");
        op.add(Builder::rehash, JsonpDeserializer.booleanDeserializer(), "rehash");
        op.add(Builder::executionHint, CardinalityExecutionMode._DESERIALIZER, "execution_hint");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CardinalityAggregation> {
        @Nullable
        private Integer precisionThreshold;
        @Nullable
        private Boolean rehash;
        @Nullable
        private CardinalityExecutionMode executionHint;

        public final Builder precisionThreshold(@Nullable Integer value) {
            this.precisionThreshold = value;
            return this;
        }

        public final Builder rehash(@Nullable Boolean value) {
            this.rehash = value;
            return this;
        }

        public final Builder executionHint(@Nullable CardinalityExecutionMode value) {
            this.executionHint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CardinalityAggregation build() {
            this._checkSingleUse();
            return new CardinalityAggregation(this);
        }
    }
}

