/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.EqlFeatures;
import co.elastic.clients.elasticsearch.xpack.usage.XpackUsageQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Eql
extends Base {
    private final EqlFeatures features;
    private final Map<String, XpackUsageQuery> queries;
    public static final JsonpDeserializer<Eql> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Eql::setupEqlDeserializer);

    private Eql(Builder builder) {
        super(builder);
        this.features = ApiTypeHelper.requireNonNull(builder.features, this, "features");
        this.queries = ApiTypeHelper.unmodifiableRequired(builder.queries, (Object)this, "queries");
    }

    public static Eql of(Function<Builder, ObjectBuilder<Eql>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final EqlFeatures features() {
        return this.features;
    }

    public final Map<String, XpackUsageQuery> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("features");
        this.features.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.queries)) {
            generator.writeKey("queries");
            generator.writeStartObject();
            for (Map.Entry<String, XpackUsageQuery> item0 : this.queries.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupEqlDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::features, EqlFeatures._DESERIALIZER, "features");
        op.add(Builder::queries, JsonpDeserializer.stringMapDeserializer(XpackUsageQuery._DESERIALIZER), "queries");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Eql> {
        private EqlFeatures features;
        private Map<String, XpackUsageQuery> queries;

        public final Builder features(EqlFeatures value) {
            this.features = value;
            return this;
        }

        public final Builder features(Function<EqlFeatures.Builder, ObjectBuilder<EqlFeatures>> fn) {
            return this.features(fn.apply(new EqlFeatures.Builder()).build());
        }

        public final Builder queries(Map<String, XpackUsageQuery> map) {
            this.queries = Builder._mapPutAll(this.queries, map);
            return this;
        }

        public final Builder queries(String key, XpackUsageQuery value) {
            this.queries = Builder._mapPut(this.queries, key, value);
            return this;
        }

        public final Builder queries(String key, Function<XpackUsageQuery.Builder, ObjectBuilder<XpackUsageQuery>> fn) {
            return this.queries(key, fn.apply(new XpackUsageQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Eql build() {
            this._checkSingleUse();
            return new Eql(this);
        }
    }
}

