/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EqlFeaturesPipes
implements JsonpSerializable {
    private final Number pipeTail;
    private final Number pipeHead;
    public static final JsonpDeserializer<EqlFeaturesPipes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesPipes::setupEqlFeaturesPipesDeserializer);

    private EqlFeaturesPipes(Builder builder) {
        this.pipeTail = ApiTypeHelper.requireNonNull(builder.pipeTail, this, "pipeTail");
        this.pipeHead = ApiTypeHelper.requireNonNull(builder.pipeHead, this, "pipeHead");
    }

    public static EqlFeaturesPipes of(Function<Builder, ObjectBuilder<EqlFeaturesPipes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number pipeTail() {
        return this.pipeTail;
    }

    public final Number pipeHead() {
        return this.pipeHead;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipe_tail");
        generator.write(this.pipeTail.doubleValue());
        generator.writeKey("pipe_head");
        generator.write(this.pipeHead.doubleValue());
    }

    protected static void setupEqlFeaturesPipesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipeTail, JsonpDeserializer.numberDeserializer(), "pipe_tail");
        op.add(Builder::pipeHead, JsonpDeserializer.numberDeserializer(), "pipe_head");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EqlFeaturesPipes> {
        private Number pipeTail;
        private Number pipeHead;

        public final Builder pipeTail(Number value) {
            this.pipeTail = value;
            return this;
        }

        public final Builder pipeHead(Number value) {
            this.pipeHead = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EqlFeaturesPipes build() {
            this._checkSingleUse();
            return new EqlFeaturesPipes(this);
        }
    }
}

