/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.enroll_kibana.Token;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EnrollKibanaResponse
implements JsonpSerializable {
    private final Token token;
    private final String httpCa;
    public static final JsonpDeserializer<EnrollKibanaResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrollKibanaResponse::setupEnrollKibanaResponseDeserializer);

    private EnrollKibanaResponse(Builder builder) {
        this.token = ApiTypeHelper.requireNonNull(builder.token, this, "token");
        this.httpCa = ApiTypeHelper.requireNonNull(builder.httpCa, this, "httpCa");
    }

    public static EnrollKibanaResponse of(Function<Builder, ObjectBuilder<EnrollKibanaResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Token token() {
        return this.token;
    }

    public final String httpCa() {
        return this.httpCa;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("token");
        this.token.serialize(generator, mapper);
        generator.writeKey("http_ca");
        generator.write(this.httpCa);
    }

    protected static void setupEnrollKibanaResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::token, Token._DESERIALIZER, "token");
        op.add(Builder::httpCa, JsonpDeserializer.stringDeserializer(), "http_ca");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EnrollKibanaResponse> {
        private Token token;
        private String httpCa;

        public final Builder token(Token value) {
            this.token = value;
            return this;
        }

        public final Builder token(Function<Token.Builder, ObjectBuilder<Token>> fn) {
            return this.token(fn.apply(new Token.Builder()).build());
        }

        public final Builder httpCa(String value) {
            this.httpCa = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrollKibanaResponse build() {
            this._checkSingleUse();
            return new EnrollKibanaResponse(this);
        }
    }
}

