/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataDescription
implements JsonpSerializable {
    @Nullable
    private final String format;
    @Nullable
    private final String timeField;
    @Nullable
    private final String timeFormat;
    @Nullable
    private final String fieldDelimiter;
    public static final JsonpDeserializer<DataDescription> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataDescription::setupDataDescriptionDeserializer);

    private DataDescription(Builder builder) {
        this.format = builder.format;
        this.timeField = builder.timeField;
        this.timeFormat = builder.timeFormat;
        this.fieldDelimiter = builder.fieldDelimiter;
    }

    public static DataDescription of(Function<Builder, ObjectBuilder<DataDescription>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String timeField() {
        return this.timeField;
    }

    @Nullable
    public final String timeFormat() {
        return this.timeFormat;
    }

    @Nullable
    public final String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.timeField != null) {
            generator.writeKey("time_field");
            generator.write(this.timeField);
        }
        if (this.timeFormat != null) {
            generator.writeKey("time_format");
            generator.write(this.timeFormat);
        }
        if (this.fieldDelimiter != null) {
            generator.writeKey("field_delimiter");
            generator.write(this.fieldDelimiter);
        }
    }

    protected static void setupDataDescriptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::timeField, JsonpDeserializer.stringDeserializer(), "time_field");
        op.add(Builder::timeFormat, JsonpDeserializer.stringDeserializer(), "time_format");
        op.add(Builder::fieldDelimiter, JsonpDeserializer.stringDeserializer(), "field_delimiter");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataDescription> {
        @Nullable
        private String format;
        @Nullable
        private String timeField;
        @Nullable
        private String timeFormat;
        @Nullable
        private String fieldDelimiter;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder timeField(@Nullable String value) {
            this.timeField = value;
            return this;
        }

        public final Builder timeFormat(@Nullable String value) {
            this.timeFormat = value;
            return this;
        }

        public final Builder fieldDelimiter(@Nullable String value) {
            this.fieldDelimiter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataDescription build() {
            this._checkSingleUse();
            return new DataDescription(this);
        }
    }
}

