/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SoftDeletes
implements JsonpSerializable {
    private final boolean enabled;
    @Nullable
    private final Time retentionLeasePeriod;
    public static final JsonpDeserializer<SoftDeletes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SoftDeletes::setupSoftDeletesDeserializer);

    private SoftDeletes(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.retentionLeasePeriod = builder.retentionLeasePeriod;
    }

    public static SoftDeletes of(Function<Builder, ObjectBuilder<SoftDeletes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Time retentionLeasePeriod() {
        return this.retentionLeasePeriod;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (this.retentionLeasePeriod != null) {
            generator.writeKey("retention_lease.period");
            this.retentionLeasePeriod.serialize(generator, mapper);
        }
    }

    protected static void setupSoftDeletesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::retentionLeasePeriod, Time._DESERIALIZER, "retention_lease.period");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SoftDeletes> {
        private Boolean enabled;
        @Nullable
        private Time retentionLeasePeriod;

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder retentionLeasePeriod(@Nullable Time value) {
            this.retentionLeasePeriod = value;
            return this;
        }

        public final Builder retentionLeasePeriod(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.retentionLeasePeriod(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SoftDeletes build() {
            this._checkSingleUse();
            return new SoftDeletes(this);
        }
    }
}

