/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.scripts_painless_execute;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PainlessContextSetup
implements JsonpSerializable {
    private final JsonData document;
    private final String index;
    private final Query query;
    public static final JsonpDeserializer<PainlessContextSetup> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PainlessContextSetup::setupPainlessContextSetupDeserializer);

    private PainlessContextSetup(Builder builder) {
        this.document = ApiTypeHelper.requireNonNull(builder.document, this, "document");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static PainlessContextSetup of(Function<Builder, ObjectBuilder<PainlessContextSetup>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final JsonData document() {
        return this.document;
    }

    public final String index() {
        return this.index;
    }

    public final Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("document");
        this.document.serialize(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    protected static void setupPainlessContextSetupDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::document, JsonData._DESERIALIZER, "document");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::query, Query._DESERIALIZER, "query");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PainlessContextSetup> {
        private JsonData document;
        private String index;
        private Query query;

        public final Builder document(JsonData value) {
            this.document = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PainlessContextSetup build() {
            this._checkSingleUse();
            return new PainlessContextSetup(this);
        }
    }
}

