/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.field_caps;

import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldCapability
implements JsonpSerializable {
    private final boolean aggregatable;
    private final List<String> indices;
    private final Map<String, JsonData> meta;
    private final List<String> nonAggregatableIndices;
    private final List<String> nonSearchableIndices;
    private final boolean searchable;
    private final String type;
    @Nullable
    private final Boolean metadataField;
    @Nullable
    private final Boolean timeSeriesDimension;
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;
    private final List<String> nonDimensionIndices;
    private final List<String> metricConflictsIndices;
    public static final JsonpDeserializer<FieldCapability> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapability::setupFieldCapabilityDeserializer);

    private FieldCapability(Builder builder) {
        this.aggregatable = ApiTypeHelper.requireNonNull(builder.aggregatable, this, "aggregatable");
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.nonAggregatableIndices = ApiTypeHelper.unmodifiable(builder.nonAggregatableIndices);
        this.nonSearchableIndices = ApiTypeHelper.unmodifiable(builder.nonSearchableIndices);
        this.searchable = ApiTypeHelper.requireNonNull(builder.searchable, this, "searchable");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.metadataField = builder.metadataField;
        this.timeSeriesDimension = builder.timeSeriesDimension;
        this.timeSeriesMetric = builder.timeSeriesMetric;
        this.nonDimensionIndices = ApiTypeHelper.unmodifiable(builder.nonDimensionIndices);
        this.metricConflictsIndices = ApiTypeHelper.unmodifiable(builder.metricConflictsIndices);
    }

    public static FieldCapability of(Function<Builder, ObjectBuilder<FieldCapability>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean aggregatable() {
        return this.aggregatable;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    public final List<String> nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public final List<String> nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public final boolean searchable() {
        return this.searchable;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean metadataField() {
        return this.metadataField;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    public final List<String> nonDimensionIndices() {
        return this.nonDimensionIndices;
    }

    public final List<String> metricConflictsIndices() {
        return this.metricConflictsIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregatable");
        generator.write(this.aggregatable);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nonAggregatableIndices)) {
            generator.writeKey("non_aggregatable_indices");
            generator.writeStartArray();
            for (String string : this.nonAggregatableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nonSearchableIndices)) {
            generator.writeKey("non_searchable_indices");
            generator.writeStartArray();
            for (String string : this.nonSearchableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("searchable");
        generator.write(this.searchable);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.metadataField != null) {
            generator.writeKey("metadata_field");
            generator.write(this.metadataField.booleanValue());
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension.booleanValue());
        }
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.nonDimensionIndices)) {
            generator.writeKey("non_dimension_indices");
            generator.writeStartArray();
            for (String string : this.nonDimensionIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metricConflictsIndices)) {
            generator.writeKey("metric_conflicts_indices");
            generator.writeStartArray();
            for (String string : this.metricConflictsIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldCapabilityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregatable, JsonpDeserializer.booleanDeserializer(), "aggregatable");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta");
        op.add(Builder::nonAggregatableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_aggregatable_indices");
        op.add(Builder::nonSearchableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_searchable_indices");
        op.add(Builder::searchable, JsonpDeserializer.booleanDeserializer(), "searchable");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::metadataField, JsonpDeserializer.booleanDeserializer(), "metadata_field");
        op.add(Builder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
        op.add(Builder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
        op.add(Builder::nonDimensionIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_dimension_indices");
        op.add(Builder::metricConflictsIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "metric_conflicts_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldCapability> {
        private Boolean aggregatable;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private List<String> nonAggregatableIndices;
        @Nullable
        private List<String> nonSearchableIndices;
        private Boolean searchable;
        private String type;
        @Nullable
        private Boolean metadataField;
        @Nullable
        private Boolean timeSeriesDimension;
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;
        @Nullable
        private List<String> nonDimensionIndices;
        @Nullable
        private List<String> metricConflictsIndices;

        public final Builder aggregatable(boolean value) {
            this.aggregatable = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder nonAggregatableIndices(List<String> list) {
            this.nonAggregatableIndices = Builder._listAddAll(this.nonAggregatableIndices, list);
            return this;
        }

        public final Builder nonAggregatableIndices(String value, String ... values) {
            this.nonAggregatableIndices = Builder._listAdd(this.nonAggregatableIndices, value, values);
            return this;
        }

        public final Builder nonSearchableIndices(List<String> list) {
            this.nonSearchableIndices = Builder._listAddAll(this.nonSearchableIndices, list);
            return this;
        }

        public final Builder nonSearchableIndices(String value, String ... values) {
            this.nonSearchableIndices = Builder._listAdd(this.nonSearchableIndices, value, values);
            return this;
        }

        public final Builder searchable(boolean value) {
            this.searchable = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder metadataField(@Nullable Boolean value) {
            this.metadataField = value;
            return this;
        }

        public final Builder timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return this;
        }

        public final Builder timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return this;
        }

        public final Builder nonDimensionIndices(List<String> list) {
            this.nonDimensionIndices = Builder._listAddAll(this.nonDimensionIndices, list);
            return this;
        }

        public final Builder nonDimensionIndices(String value, String ... values) {
            this.nonDimensionIndices = Builder._listAdd(this.nonDimensionIndices, value, values);
            return this;
        }

        public final Builder metricConflictsIndices(List<String> list) {
            this.metricConflictsIndices = Builder._listAddAll(this.metricConflictsIndices, list);
            return this;
        }

        public final Builder metricConflictsIndices(String value, String ... values) {
            this.metricConflictsIndices = Builder._listAdd(this.metricConflictsIndices, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldCapability build() {
            this._checkSingleUse();
            return new FieldCapability(this);
        }
    }
}

