/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.pending_tasks;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PendingTask
implements JsonpSerializable {
    private final boolean executing;
    private final int insertOrder;
    private final String priority;
    private final String source;
    private final String timeInQueue;
    private final int timeInQueueMillis;
    public static final JsonpDeserializer<PendingTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTask::setupPendingTaskDeserializer);

    private PendingTask(Builder builder) {
        this.executing = ApiTypeHelper.requireNonNull(builder.executing, this, "executing");
        this.insertOrder = ApiTypeHelper.requireNonNull(builder.insertOrder, this, "insertOrder");
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.timeInQueue = ApiTypeHelper.requireNonNull(builder.timeInQueue, this, "timeInQueue");
        this.timeInQueueMillis = ApiTypeHelper.requireNonNull(builder.timeInQueueMillis, this, "timeInQueueMillis");
    }

    public static PendingTask of(Function<Builder, ObjectBuilder<PendingTask>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean executing() {
        return this.executing;
    }

    public final int insertOrder() {
        return this.insertOrder;
    }

    public final String priority() {
        return this.priority;
    }

    public final String source() {
        return this.source;
    }

    public final String timeInQueue() {
        return this.timeInQueue;
    }

    public final int timeInQueueMillis() {
        return this.timeInQueueMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("executing");
        generator.write(this.executing);
        generator.writeKey("insert_order");
        generator.write(this.insertOrder);
        generator.writeKey("priority");
        generator.write(this.priority);
        generator.writeKey("source");
        generator.write(this.source);
        generator.writeKey("time_in_queue");
        generator.write(this.timeInQueue);
        generator.writeKey("time_in_queue_millis");
        generator.write(this.timeInQueueMillis);
    }

    protected static void setupPendingTaskDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::executing, JsonpDeserializer.booleanDeserializer(), "executing");
        op.add(Builder::insertOrder, JsonpDeserializer.integerDeserializer(), "insert_order");
        op.add(Builder::priority, JsonpDeserializer.stringDeserializer(), "priority");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.add(Builder::timeInQueue, JsonpDeserializer.stringDeserializer(), "time_in_queue");
        op.add(Builder::timeInQueueMillis, JsonpDeserializer.integerDeserializer(), "time_in_queue_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PendingTask> {
        private Boolean executing;
        private Integer insertOrder;
        private String priority;
        private String source;
        private String timeInQueue;
        private Integer timeInQueueMillis;

        public final Builder executing(boolean value) {
            this.executing = value;
            return this;
        }

        public final Builder insertOrder(int value) {
            this.insertOrder = value;
            return this;
        }

        public final Builder priority(String value) {
            this.priority = value;
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        public final Builder timeInQueue(String value) {
            this.timeInQueue = value;
            return this;
        }

        public final Builder timeInQueueMillis(int value) {
            this.timeInQueueMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PendingTask build() {
            this._checkSingleUse();
            return new PendingTask(this);
        }
    }
}

