/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Preprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TargetMeanEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final String featureName;
    private final Map<String, Double> targetMap;
    private final double defaultValue;
    public static final JsonpDeserializer<TargetMeanEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TargetMeanEncodingPreprocessor::setupTargetMeanEncodingPreprocessorDeserializer);

    private TargetMeanEncodingPreprocessor(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.targetMap = ApiTypeHelper.unmodifiableRequired(builder.targetMap, (Object)this, "targetMap");
        this.defaultValue = ApiTypeHelper.requireNonNull(builder.defaultValue, this, "defaultValue");
    }

    public static TargetMeanEncodingPreprocessor of(Function<Builder, ObjectBuilder<TargetMeanEncodingPreprocessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Preprocessor.Kind _preprocessorKind() {
        return Preprocessor.Kind.TargetMeanEncoding;
    }

    public final String field() {
        return this.field;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final Map<String, Double> targetMap() {
        return this.targetMap;
    }

    public final double defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        if (ApiTypeHelper.isDefined(this.targetMap)) {
            generator.writeKey("target_map");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.targetMap.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("default_value");
        generator.write(this.defaultValue);
    }

    protected static void setupTargetMeanEncodingPreprocessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::targetMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "target_map");
        op.add(Builder::defaultValue, JsonpDeserializer.doubleDeserializer(), "default_value");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TargetMeanEncodingPreprocessor> {
        private String field;
        private String featureName;
        private Map<String, Double> targetMap;
        private Double defaultValue;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder targetMap(Map<String, Double> map) {
            this.targetMap = Builder._mapPutAll(this.targetMap, map);
            return this;
        }

        public final Builder targetMap(String key, Double value) {
            this.targetMap = Builder._mapPut(this.targetMap, key, value);
            return this;
        }

        public final Builder defaultValue(double value) {
            this.defaultValue = value;
            return this;
        }

        @Override
        public TargetMeanEncodingPreprocessor build() {
            this._checkSingleUse();
            return new TargetMeanEncodingPreprocessor(this);
        }
    }
}

