/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.watcher.AckWatchRequest;
import co.elastic.clients.elasticsearch.watcher.AckWatchResponse;
import co.elastic.clients.elasticsearch.watcher.ActivateWatchRequest;
import co.elastic.clients.elasticsearch.watcher.ActivateWatchResponse;
import co.elastic.clients.elasticsearch.watcher.DeactivateWatchRequest;
import co.elastic.clients.elasticsearch.watcher.DeactivateWatchResponse;
import co.elastic.clients.elasticsearch.watcher.DeleteWatchRequest;
import co.elastic.clients.elasticsearch.watcher.DeleteWatchResponse;
import co.elastic.clients.elasticsearch.watcher.ExecuteWatchRequest;
import co.elastic.clients.elasticsearch.watcher.ExecuteWatchResponse;
import co.elastic.clients.elasticsearch.watcher.GetWatchRequest;
import co.elastic.clients.elasticsearch.watcher.GetWatchResponse;
import co.elastic.clients.elasticsearch.watcher.PutWatchRequest;
import co.elastic.clients.elasticsearch.watcher.PutWatchResponse;
import co.elastic.clients.elasticsearch.watcher.QueryWatchesRequest;
import co.elastic.clients.elasticsearch.watcher.QueryWatchesResponse;
import co.elastic.clients.elasticsearch.watcher.StartWatcherRequest;
import co.elastic.clients.elasticsearch.watcher.StartWatcherResponse;
import co.elastic.clients.elasticsearch.watcher.StopWatcherRequest;
import co.elastic.clients.elasticsearch.watcher.StopWatcherResponse;
import co.elastic.clients.elasticsearch.watcher.WatcherStatsRequest;
import co.elastic.clients.elasticsearch.watcher.WatcherStatsResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchWatcherAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchWatcherAsyncClient> {
    public ElasticsearchWatcherAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchWatcherAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchWatcherAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchWatcherAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<AckWatchResponse> ackWatch(AckWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)AckWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<AckWatchResponse> ackWatch(Function<AckWatchRequest.Builder, ObjectBuilder<AckWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.ackWatch(fn.apply(new AckWatchRequest.Builder()).build());
    }

    public CompletableFuture<ActivateWatchResponse> activateWatch(ActivateWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ActivateWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<ActivateWatchResponse> activateWatch(Function<ActivateWatchRequest.Builder, ObjectBuilder<ActivateWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.activateWatch(fn.apply(new ActivateWatchRequest.Builder()).build());
    }

    public CompletableFuture<DeactivateWatchResponse> deactivateWatch(DeactivateWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeactivateWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeactivateWatchResponse> deactivateWatch(Function<DeactivateWatchRequest.Builder, ObjectBuilder<DeactivateWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.deactivateWatch(fn.apply(new DeactivateWatchRequest.Builder()).build());
    }

    public CompletableFuture<DeleteWatchResponse> deleteWatch(DeleteWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteWatchResponse> deleteWatch(Function<DeleteWatchRequest.Builder, ObjectBuilder<DeleteWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.deleteWatch(fn.apply(new DeleteWatchRequest.Builder()).build());
    }

    public CompletableFuture<ExecuteWatchResponse> executeWatch(ExecuteWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ExecuteWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<ExecuteWatchResponse> executeWatch(Function<ExecuteWatchRequest.Builder, ObjectBuilder<ExecuteWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.executeWatch(fn.apply(new ExecuteWatchRequest.Builder()).build());
    }

    public CompletableFuture<ExecuteWatchResponse> executeWatch() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new ExecuteWatchRequest.Builder().build(), ExecuteWatchRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetWatchResponse> getWatch(GetWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetWatchResponse> getWatch(Function<GetWatchRequest.Builder, ObjectBuilder<GetWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.getWatch(fn.apply(new GetWatchRequest.Builder()).build());
    }

    public CompletableFuture<PutWatchResponse> putWatch(PutWatchRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutWatchRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutWatchResponse> putWatch(Function<PutWatchRequest.Builder, ObjectBuilder<PutWatchRequest>> fn) throws IOException, ElasticsearchException {
        return this.putWatch(fn.apply(new PutWatchRequest.Builder()).build());
    }

    public CompletableFuture<QueryWatchesResponse> queryWatches(QueryWatchesRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)QueryWatchesRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<QueryWatchesResponse> queryWatches(Function<QueryWatchesRequest.Builder, ObjectBuilder<QueryWatchesRequest>> fn) throws IOException, ElasticsearchException {
        return this.queryWatches(fn.apply(new QueryWatchesRequest.Builder()).build());
    }

    public CompletableFuture<QueryWatchesResponse> queryWatches() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new QueryWatchesRequest.Builder().build(), QueryWatchesRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<StartWatcherResponse> start() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(StartWatcherRequest._INSTANCE, StartWatcherRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<WatcherStatsResponse> stats(WatcherStatsRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)WatcherStatsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<WatcherStatsResponse> stats(Function<WatcherStatsRequest.Builder, ObjectBuilder<WatcherStatsRequest>> fn) throws IOException, ElasticsearchException {
        return this.stats(fn.apply(new WatcherStatsRequest.Builder()).build());
    }

    public CompletableFuture<WatcherStatsResponse> stats() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new WatcherStatsRequest.Builder().build(), WatcherStatsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<StopWatcherResponse> stop() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(StopWatcherRequest._INSTANCE, StopWatcherRequest._ENDPOINT, this.transportOptions);
    }
}

