/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionSuggestOption;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggestOption;
import co.elastic.clients.elasticsearch.core.search.TermSuggestOption;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

public class SuggestOption<TDocument>
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final JsonpSerializer<TDocument> tDocumentSerializer = null;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SuggestOption(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private SuggestOption(Builder<TDocument> builder) {
        this._kind = ApiTypeHelper.requireNonNull(((Builder)builder)._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(((Builder)builder)._value, builder, "<variant value>");
    }

    public static <TDocument> SuggestOption<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<SuggestOption<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggestOption<TDocument> completion() {
        return (CompletionSuggestOption)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggestOption phrase() {
        return (PhraseSuggestOption)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggestOption term() {
        return (TermSuggestOption)TaggedUnionUtils.get(this, Kind.Term);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<SuggestOption<TDocument>> createSuggestOptionDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return new UnionDeserializer.Builder<SuggestOption, Kind, Object>(SuggestOption::new, false).addMember(Kind.Completion, CompletionSuggestOption.createCompletionSuggestOptionDeserializer(tDocumentDeserializer)).addMember(Kind.Phrase, PhraseSuggestOption._DESERIALIZER).addMember(Kind.Term, TermSuggestOption._DESERIALIZER).build();
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<SuggestOption<TDocument>> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<SuggestOption<TDocument>> completion(CompletionSuggestOption<TDocument> v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SuggestOption<TDocument>> completion(Function<CompletionSuggestOption.Builder<TDocument>, ObjectBuilder<CompletionSuggestOption<TDocument>>> fn) {
            return this.completion(fn.apply(new CompletionSuggestOption.Builder()).build());
        }

        public ObjectBuilder<SuggestOption<TDocument>> phrase(PhraseSuggestOption v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SuggestOption<TDocument>> phrase(Function<PhraseSuggestOption.Builder, ObjectBuilder<PhraseSuggestOption>> fn) {
            return this.phrase(fn.apply(new PhraseSuggestOption.Builder()).build());
        }

        public ObjectBuilder<SuggestOption<TDocument>> term(TermSuggestOption v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SuggestOption<TDocument>> term(Function<TermSuggestOption.Builder, ObjectBuilder<TermSuggestOption>> fn) {
            return this.term(fn.apply(new TermSuggestOption.Builder()).build());
        }

        @Override
        public SuggestOption<TDocument> build() {
            this._checkSingleUse();
            return new SuggestOption(this);
        }
    }

    public static enum Kind {
        Completion,
        Phrase,
        Term;

    }
}

