/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizationMode;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KuromojiTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final Boolean discardPunctuation;
    private final KuromojiTokenizationMode mode;
    @Nullable
    private final Integer nbestCost;
    @Nullable
    private final String nbestExamples;
    @Nullable
    private final String userDictionary;
    private final List<String> userDictionaryRules;
    @Nullable
    private final Boolean discardCompoundToken;
    public static final JsonpDeserializer<KuromojiTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiTokenizer::setupKuromojiTokenizerDeserializer);

    private KuromojiTokenizer(Builder builder) {
        super(builder);
        this.discardPunctuation = builder.discardPunctuation;
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.nbestCost = builder.nbestCost;
        this.nbestExamples = builder.nbestExamples;
        this.userDictionary = builder.userDictionary;
        this.userDictionaryRules = ApiTypeHelper.unmodifiable(builder.userDictionaryRules);
        this.discardCompoundToken = builder.discardCompoundToken;
    }

    public static KuromojiTokenizer of(Function<Builder, ObjectBuilder<KuromojiTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.KuromojiTokenizer;
    }

    @Nullable
    public final Boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    public final KuromojiTokenizationMode mode() {
        return this.mode;
    }

    @Nullable
    public final Integer nbestCost() {
        return this.nbestCost;
    }

    @Nullable
    public final String nbestExamples() {
        return this.nbestExamples;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    public final List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Nullable
    public final Boolean discardCompoundToken() {
        return this.discardCompoundToken;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_tokenizer");
        super.serializeInternal(generator, mapper);
        if (this.discardPunctuation != null) {
            generator.writeKey("discard_punctuation");
            generator.write(this.discardPunctuation.booleanValue());
        }
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.nbestCost != null) {
            generator.writeKey("nbest_cost");
            generator.write(this.nbestCost.intValue());
        }
        if (this.nbestExamples != null) {
            generator.writeKey("nbest_examples");
            generator.write(this.nbestExamples);
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
        if (ApiTypeHelper.isDefined(this.userDictionaryRules)) {
            generator.writeKey("user_dictionary_rules");
            generator.writeStartArray();
            for (String item0 : this.userDictionaryRules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.discardCompoundToken != null) {
            generator.writeKey("discard_compound_token");
            generator.write(this.discardCompoundToken.booleanValue());
        }
    }

    protected static void setupKuromojiTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation");
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode");
        op.add(Builder::nbestCost, JsonpDeserializer.integerDeserializer(), "nbest_cost");
        op.add(Builder::nbestExamples, JsonpDeserializer.stringDeserializer(), "nbest_examples");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules");
        op.add(Builder::discardCompoundToken, JsonpDeserializer.booleanDeserializer(), "discard_compound_token");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiTokenizer> {
        @Nullable
        private Boolean discardPunctuation;
        private KuromojiTokenizationMode mode;
        @Nullable
        private Integer nbestCost;
        @Nullable
        private String nbestExamples;
        @Nullable
        private String userDictionary;
        @Nullable
        private List<String> userDictionaryRules;
        @Nullable
        private Boolean discardCompoundToken;

        public final Builder discardPunctuation(@Nullable Boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        public final Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        public final Builder nbestCost(@Nullable Integer value) {
            this.nbestCost = value;
            return this;
        }

        public final Builder nbestExamples(@Nullable String value) {
            this.nbestExamples = value;
            return this;
        }

        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        public final Builder userDictionaryRules(List<String> list) {
            this.userDictionaryRules = Builder._listAddAll(this.userDictionaryRules, list);
            return this;
        }

        public final Builder userDictionaryRules(String value, String ... values) {
            this.userDictionaryRules = Builder._listAdd(this.userDictionaryRules, value, values);
            return this;
        }

        public final Builder discardCompoundToken(@Nullable Boolean value) {
            this.discardCompoundToken = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiTokenizer build() {
            this._checkSingleUse();
            return new KuromojiTokenizer(this);
        }
    }
}

