/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cat.CatDfaColumn;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDataFrameAnalyticsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MlDataFrameAnalyticsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    private final List<CatDfaColumn> h;
    @Nullable
    private final String id;
    private final List<CatDfaColumn> s;
    @Nullable
    private final Time time;
    public static final Endpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse>("es/cat.ml_data_frame_analytics", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time._toJsonString());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDataFrameAnalyticsResponse._DESERIALIZER);

    private MlDataFrameAnalyticsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.id = builder.id;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static MlDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<MlDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<CatDfaColumn> h() {
        return this.h;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final List<CatDfaColumn> s() {
        return this.s;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MlDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<CatDfaColumn> h;
        @Nullable
        private String id;
        @Nullable
        private List<CatDfaColumn> s;
        @Nullable
        private Time time;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder h(List<CatDfaColumn> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(CatDfaColumn value, CatDfaColumn ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder s(List<CatDfaColumn> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(CatDfaColumn value, CatDfaColumn ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new MlDataFrameAnalyticsRequest(this);
        }
    }
}

