/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InProgress
implements JsonpSerializable {
    private final String name;
    private final String startTimeMillis;
    private final String state;
    private final String uuid;
    public static final JsonpDeserializer<InProgress> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InProgress::setupInProgressDeserializer);

    private InProgress(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.startTimeMillis = ApiTypeHelper.requireNonNull(builder.startTimeMillis, this, "startTimeMillis");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.uuid = ApiTypeHelper.requireNonNull(builder.uuid, this, "uuid");
    }

    public static InProgress of(Function<Builder, ObjectBuilder<InProgress>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String startTimeMillis() {
        return this.startTimeMillis;
    }

    public final String state() {
        return this.state;
    }

    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("start_time_millis");
        generator.write(this.startTimeMillis);
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("uuid");
        generator.write(this.uuid);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInProgressDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::startTimeMillis, JsonpDeserializer.stringDeserializer(), "start_time_millis");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InProgress> {
        private String name;
        private String startTimeMillis;
        private String state;
        private String uuid;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder startTimeMillis(String value) {
            this.startTimeMillis = value;
            return this;
        }

        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        public final Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InProgress build() {
            this._checkSingleUse();
            return new InProgress(this);
        }
    }
}

