/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.NumberPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class StandardNumberProperty
extends NumberPropertyBase {
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Script script;
    @Nullable
    private final OnScriptError onScriptError;

    protected StandardNumberProperty(AbstractBuilder<?> builder) {
        super((NumberPropertyBase.AbstractBuilder<?>)builder);
        this.coerce = ((AbstractBuilder)builder).coerce;
        this.script = ((AbstractBuilder)builder).script;
        this.onScriptError = ((AbstractBuilder)builder).onScriptError;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStandardNumberPropertyDeserializer(ObjectDeserializer<BuilderT> op) {
        NumberPropertyBase.setupNumberPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
        op.add(AbstractBuilder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends NumberPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Boolean coerce;
        @Nullable
        private Script script;
        @Nullable
        private OnScriptError onScriptError;

        public final BuilderT coerce(@Nullable Boolean value) {
            this.coerce = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT script(@Nullable Script value) {
            this.script = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final BuilderT onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

