/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JoinProperty
extends PropertyBase
implements PropertyVariant {
    private final Map<String, List<String>> relations;
    public static final JsonpDeserializer<JoinProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JoinProperty::setupJoinPropertyDeserializer);

    private JoinProperty(Builder builder) {
        super(builder);
        this.relations = ApiTypeHelper.unmodifiable(builder.relations);
    }

    public static JoinProperty of(Function<Builder, ObjectBuilder<JoinProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Join;
    }

    public final Map<String, List<String>> relations() {
        return this.relations;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "join");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.relations)) {
            generator.writeKey("relations");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.relations.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupJoinPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::relations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "relations");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JoinProperty> {
        @Nullable
        private Map<String, List<String>> relations;

        public final Builder relations(Map<String, List<String>> map) {
            this.relations = Builder._mapPutAll(this.relations, map);
            return this;
        }

        public final Builder relations(String key, List<String> value) {
            this.relations = Builder._mapPut(this.relations, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JoinProperty build() {
            this._checkSingleUse();
            return new JoinProperty(this);
        }
    }
}

