/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Latest
implements JsonpSerializable {
    private final String sort;
    private final List<String> uniqueKey;
    public static final JsonpDeserializer<Latest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Latest::setupLatestDeserializer);

    private Latest(Builder builder) {
        this.sort = ApiTypeHelper.requireNonNull(builder.sort, this, "sort");
        this.uniqueKey = ApiTypeHelper.unmodifiableRequired(builder.uniqueKey, (Object)this, "uniqueKey");
    }

    public static Latest of(Function<Builder, ObjectBuilder<Latest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String sort() {
        return this.sort;
    }

    public final List<String> uniqueKey() {
        return this.uniqueKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("sort");
        generator.write(this.sort);
        if (ApiTypeHelper.isDefined(this.uniqueKey)) {
            generator.writeKey("unique_key");
            generator.writeStartArray();
            for (String item0 : this.uniqueKey) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupLatestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort");
        op.add(Builder::uniqueKey, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "unique_key");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Latest> {
        private String sort;
        private List<String> uniqueKey;

        public final Builder sort(String value) {
            this.sort = value;
            return this;
        }

        public final Builder uniqueKey(List<String> list) {
            this.uniqueKey = Builder._listAddAll(this.uniqueKey, list);
            return this;
        }

        public final Builder uniqueKey(String value, String ... values) {
            this.uniqueKey = Builder._listAdd(this.uniqueKey, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Latest build() {
            this._checkSingleUse();
            return new Latest(this);
        }
    }
}

