/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoSettingsNode
implements JsonpSerializable {
    private final String name;
    private final Map<String, JsonData> attr;
    @Nullable
    private final String maxLocalStorageNodes;
    public static final JsonpDeserializer<NodeInfoSettingsNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsNode::setupNodeInfoSettingsNodeDeserializer);

    private NodeInfoSettingsNode(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.attr = ApiTypeHelper.unmodifiableRequired(builder.attr, (Object)this, "attr");
        this.maxLocalStorageNodes = builder.maxLocalStorageNodes;
    }

    public static NodeInfoSettingsNode of(Function<Builder, ObjectBuilder<NodeInfoSettingsNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final Map<String, JsonData> attr() {
        return this.attr;
    }

    @Nullable
    public final String maxLocalStorageNodes() {
        return this.maxLocalStorageNodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.attr)) {
            generator.writeKey("attr");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.attr.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxLocalStorageNodes != null) {
            generator.writeKey("max_local_storage_nodes");
            generator.write(this.maxLocalStorageNodes);
        }
    }

    protected static void setupNodeInfoSettingsNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::attr, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "attr");
        op.add(Builder::maxLocalStorageNodes, JsonpDeserializer.stringDeserializer(), "max_local_storage_nodes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoSettingsNode> {
        private String name;
        private Map<String, JsonData> attr;
        @Nullable
        private String maxLocalStorageNodes;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder attr(Map<String, JsonData> map) {
            this.attr = Builder._mapPutAll(this.attr, map);
            return this;
        }

        public final Builder attr(String key, JsonData value) {
            this.attr = Builder._mapPut(this.attr, key, value);
            return this;
        }

        public final Builder maxLocalStorageNodes(@Nullable String value) {
            this.maxLocalStorageNodes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoSettingsNode build() {
            this._checkSingleUse();
            return new NodeInfoSettingsNode(this);
        }
    }
}

