/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class NodesResponseBase
implements JsonpSerializable {
    @Nullable
    private final NodeStatistics nodeStats;

    protected NodesResponseBase(AbstractBuilder<?> builder) {
        this.nodeStats = ((AbstractBuilder)builder).nodeStats;
    }

    @Nullable
    public final NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.nodeStats != null) {
            generator.writeKey("_nodes");
            this.nodeStats.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupNodesResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private NodeStatistics nodeStats;

        protected AbstractBuilder() {
        }

        public final BuilderT nodeStats(@Nullable NodeStatistics value) {
            this.nodeStats = value;
            return (BuilderT)this.self();
        }

        public final BuilderT nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

