/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class StartDatafeedResponse
implements JsonpSerializable {
    private final List<String> node;
    private final boolean started;
    public static final JsonpDeserializer<StartDatafeedResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StartDatafeedResponse::setupStartDatafeedResponseDeserializer);

    private StartDatafeedResponse(Builder builder) {
        this.node = ApiTypeHelper.unmodifiableRequired(builder.node, (Object)this, "node");
        this.started = ApiTypeHelper.requireNonNull(builder.started, this, "started");
    }

    public static StartDatafeedResponse of(Function<Builder, ObjectBuilder<StartDatafeedResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> node() {
        return this.node;
    }

    public final boolean started() {
        return this.started;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.node)) {
            generator.writeKey("node");
            generator.writeStartArray();
            for (String item0 : this.node) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("started");
        generator.write(this.started);
    }

    protected static void setupStartDatafeedResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node");
        op.add(Builder::started, JsonpDeserializer.booleanDeserializer(), "started");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StartDatafeedResponse> {
        private List<String> node;
        private Boolean started;

        public final Builder node(List<String> list) {
            this.node = Builder._listAddAll(this.node, list);
            return this;
        }

        public final Builder node(String value, String ... values) {
            this.node = Builder._listAdd(this.node, value, values);
            return this;
        }

        public final Builder started(boolean value) {
            this.started = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StartDatafeedResponse build() {
            this._checkSingleUse();
            return new StartDatafeedResponse(this);
        }
    }
}

