/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.StartDatafeedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StartDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    private final String datafeedId;
    @Nullable
    private final Time end;
    @Nullable
    private final Time start;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<StartDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StartDatafeedRequest::setupStartDatafeedRequestDeserializer);
    public static final Endpoint<StartDatafeedRequest, StartDatafeedResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StartDatafeedRequest, StartDatafeedResponse>("es/ml.start_datafeed", request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, StartDatafeedResponse._DESERIALIZER);

    private StartDatafeedRequest(Builder builder) {
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.end = builder.end;
        this.start = builder.start;
        this.timeout = builder.timeout;
    }

    public static StartDatafeedRequest of(Function<Builder, ObjectBuilder<StartDatafeedRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final Time end() {
        return this.end;
    }

    @Nullable
    public final Time start() {
        return this.start;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    protected static void setupStartDatafeedRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::end, Time._DESERIALIZER, "end");
        op.add(Builder::start, Time._DESERIALIZER, "start");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StartDatafeedRequest> {
        private String datafeedId;
        @Nullable
        private Time end;
        @Nullable
        private Time start;
        @Nullable
        private Time timeout;

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder end(@Nullable Time value) {
            this.end = value;
            return this;
        }

        public final Builder end(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.end(fn.apply(new Time.Builder()).build());
        }

        public final Builder start(@Nullable Time value) {
            this.start = value;
            return this;
        }

        public final Builder start(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.start(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StartDatafeedRequest build() {
            this._checkSingleUse();
            return new StartDatafeedRequest(this);
        }
    }
}

