/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SourceField
implements JsonpSerializable {
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String compressThreshold;
    @Nullable
    private final Boolean enabled;
    private final List<String> excludes;
    private final List<String> includes;
    public static final JsonpDeserializer<SourceField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceField::setupSourceFieldDeserializer);

    private SourceField(Builder builder) {
        this.compress = builder.compress;
        this.compressThreshold = builder.compressThreshold;
        this.enabled = builder.enabled;
        this.excludes = ApiTypeHelper.unmodifiable(builder.excludes);
        this.includes = ApiTypeHelper.unmodifiable(builder.includes);
    }

    public static SourceField of(Function<Builder, ObjectBuilder<SourceField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean compress() {
        return this.compress;
    }

    @Nullable
    public final String compressThreshold() {
        return this.compressThreshold;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    public final List<String> excludes() {
        return this.excludes;
    }

    public final List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.compressThreshold != null) {
            generator.writeKey("compress_threshold");
            generator.write(this.compressThreshold);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.excludes)) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.includes)) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSourceFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress");
        op.add(Builder::compressThreshold, JsonpDeserializer.stringDeserializer(), "compress_threshold");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes");
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SourceField> {
        @Nullable
        private Boolean compress;
        @Nullable
        private String compressThreshold;
        @Nullable
        private Boolean enabled;
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public final Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        public final Builder compressThreshold(@Nullable String value) {
            this.compressThreshold = value;
            return this;
        }

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder excludes(List<String> list) {
            this.excludes = Builder._listAddAll(this.excludes, list);
            return this;
        }

        public final Builder excludes(String value, String ... values) {
            this.excludes = Builder._listAdd(this.excludes, value, values);
            return this;
        }

        public final Builder includes(List<String> list) {
            this.includes = Builder._listAddAll(this.includes, list);
            return this;
        }

        public final Builder includes(String value, String ... values) {
            this.includes = Builder._listAdd(this.includes, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SourceField build() {
            this._checkSingleUse();
            return new SourceField(this);
        }
    }
}

