/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.Job;
import co.elastic.clients.elasticsearch.xpack.usage.AllJobs;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Jobs
implements JsonpSerializable {
    private final Map<String, Job> jobs;
    @Nullable
    private final AllJobs all;
    public static final JsonpDeserializer<Jobs> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Jobs::setupJobsDeserializer);

    private Jobs(Builder builder) {
        this.jobs = ApiTypeHelper.unmodifiable(builder.jobs);
        this.all = builder.all;
    }

    public static Jobs of(Function<Builder, ObjectBuilder<Jobs>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Job> jobs() {
        return this.jobs;
    }

    @Nullable
    public final AllJobs all() {
        return this.all;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, Job> item0 : this.jobs.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.all != null) {
            generator.writeKey("_all");
            this.all.serialize(generator, mapper);
        }
    }

    protected static void setupJobsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::all, AllJobs._DESERIALIZER, "_all");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).jobs == null) {
                ((Builder)builder).jobs = new HashMap();
            }
            ((Builder)builder).jobs.put(name, Job._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Jobs> {
        @Nullable
        private Map<String, Job> jobs = new HashMap<String, Job>();
        @Nullable
        private AllJobs all;

        public final Builder jobs(Map<String, Job> map) {
            this.jobs = Builder._mapPutAll(this.jobs, map);
            return this;
        }

        public final Builder jobs(String key, Job value) {
            this.jobs = Builder._mapPut(this.jobs, key, value);
            return this;
        }

        public final Builder jobs(String key, Function<Job.Builder, ObjectBuilder<Job>> fn) {
            return this.jobs(key, fn.apply(new Job.Builder()).build());
        }

        public final Builder all(@Nullable AllJobs value) {
            this.all = value;
            return this;
        }

        public final Builder all(Function<AllJobs.Builder, ObjectBuilder<AllJobs>> fn) {
            return this.all(fn.apply(new AllJobs.Builder()).build());
        }

        @Override
        public Jobs build() {
            this._checkSingleUse();
            return new Jobs(this);
        }
    }
}

