/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ConfusionMatrixThreshold
implements JsonpSerializable {
    private final int truePositive;
    private final int falsePositive;
    private final int trueNegative;
    private final int falseNegative;
    public static final JsonpDeserializer<ConfusionMatrixThreshold> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixThreshold::setupConfusionMatrixThresholdDeserializer);

    private ConfusionMatrixThreshold(Builder builder) {
        this.truePositive = ApiTypeHelper.requireNonNull(builder.truePositive, this, "truePositive");
        this.falsePositive = ApiTypeHelper.requireNonNull(builder.falsePositive, this, "falsePositive");
        this.trueNegative = ApiTypeHelper.requireNonNull(builder.trueNegative, this, "trueNegative");
        this.falseNegative = ApiTypeHelper.requireNonNull(builder.falseNegative, this, "falseNegative");
    }

    public static ConfusionMatrixThreshold of(Function<Builder, ObjectBuilder<ConfusionMatrixThreshold>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int truePositive() {
        return this.truePositive;
    }

    public final int falsePositive() {
        return this.falsePositive;
    }

    public final int trueNegative() {
        return this.trueNegative;
    }

    public final int falseNegative() {
        return this.falseNegative;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("tp");
        generator.write(this.truePositive);
        generator.writeKey("fp");
        generator.write(this.falsePositive);
        generator.writeKey("tn");
        generator.write(this.trueNegative);
        generator.writeKey("fn");
        generator.write(this.falseNegative);
    }

    protected static void setupConfusionMatrixThresholdDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::truePositive, JsonpDeserializer.integerDeserializer(), "tp");
        op.add(Builder::falsePositive, JsonpDeserializer.integerDeserializer(), "fp");
        op.add(Builder::trueNegative, JsonpDeserializer.integerDeserializer(), "tn");
        op.add(Builder::falseNegative, JsonpDeserializer.integerDeserializer(), "fn");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ConfusionMatrixThreshold> {
        private Integer truePositive;
        private Integer falsePositive;
        private Integer trueNegative;
        private Integer falseNegative;

        public final Builder truePositive(int value) {
            this.truePositive = value;
            return this;
        }

        public final Builder falsePositive(int value) {
            this.falsePositive = value;
            return this;
        }

        public final Builder trueNegative(int value) {
            this.trueNegative = value;
            return this;
        }

        public final Builder falseNegative(int value) {
            this.falseNegative = value;
            return this;
        }

        @Override
        public ConfusionMatrixThreshold build() {
            this._checkSingleUse();
            return new ConfusionMatrixThreshold(this);
        }
    }
}

