/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status;

import co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status.MigrationFeatureIndexInfo;
import co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status.MigrationStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class MigrationFeature
implements JsonpSerializable {
    private final String featureName;
    private final String minimumIndexVersion;
    private final MigrationStatus migrationStatus;
    private final List<MigrationFeatureIndexInfo> indices;
    public static final JsonpDeserializer<MigrationFeature> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrationFeature::setupMigrationFeatureDeserializer);

    private MigrationFeature(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.minimumIndexVersion = ApiTypeHelper.requireNonNull(builder.minimumIndexVersion, this, "minimumIndexVersion");
        this.migrationStatus = ApiTypeHelper.requireNonNull(builder.migrationStatus, this, "migrationStatus");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static MigrationFeature of(Function<Builder, ObjectBuilder<MigrationFeature>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String featureName() {
        return this.featureName;
    }

    public final String minimumIndexVersion() {
        return this.minimumIndexVersion;
    }

    public final MigrationStatus migrationStatus() {
        return this.migrationStatus;
    }

    public final List<MigrationFeatureIndexInfo> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("minimum_index_version");
        generator.write(this.minimumIndexVersion);
        generator.writeKey("migration_status");
        this.migrationStatus.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (MigrationFeatureIndexInfo item0 : this.indices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMigrationFeatureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::minimumIndexVersion, JsonpDeserializer.stringDeserializer(), "minimum_index_version");
        op.add(Builder::migrationStatus, MigrationStatus._DESERIALIZER, "migration_status");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(MigrationFeatureIndexInfo._DESERIALIZER), "indices");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MigrationFeature> {
        private String featureName;
        private String minimumIndexVersion;
        private MigrationStatus migrationStatus;
        private List<MigrationFeatureIndexInfo> indices;

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder minimumIndexVersion(String value) {
            this.minimumIndexVersion = value;
            return this;
        }

        public final Builder migrationStatus(MigrationStatus value) {
            this.migrationStatus = value;
            return this;
        }

        public final Builder indices(List<MigrationFeatureIndexInfo> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(MigrationFeatureIndexInfo value, MigrationFeatureIndexInfo ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<MigrationFeatureIndexInfo.Builder, ObjectBuilder<MigrationFeatureIndexInfo>> fn) {
            return this.indices(fn.apply(new MigrationFeatureIndexInfo.Builder()).build(), new MigrationFeatureIndexInfo[0]);
        }

        @Override
        public MigrationFeature build() {
            this._checkSingleUse();
            return new MigrationFeature(this);
        }
    }
}

