/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.segments.IndexSegment;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class SegmentsResponse
implements JsonpSerializable {
    private final Map<String, IndexSegment> indices;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<SegmentsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsResponse::setupSegmentsResponseDeserializer);

    private SegmentsResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static SegmentsResponse of(Function<Builder, ObjectBuilder<SegmentsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, IndexSegment> indices() {
        return this.indices;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndexSegment> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupSegmentsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexSegment._DESERIALIZER), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SegmentsResponse> {
        private Map<String, IndexSegment> indices;
        private ShardStatistics shards;

        public final Builder indices(Map<String, IndexSegment> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, IndexSegment value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<IndexSegment.Builder, ObjectBuilder<IndexSegment>> fn) {
            return this.indices(key, fn.apply(new IndexSegment.Builder()).build());
        }

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public SegmentsResponse build() {
            this._checkSingleUse();
            return new SegmentsResponse(this);
        }
    }
}

