/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesOptions
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean ignoreThrottled;
    public static final JsonpDeserializer<IndicesOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesOptions::setupIndicesOptionsDeserializer);

    private IndicesOptions(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.ignoreThrottled = builder.ignoreThrottled;
    }

    public static IndicesOptions of(Function<Builder, ObjectBuilder<IndicesOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoIndices != null) {
            generator.writeKey("allow_no_indices");
            generator.write(this.allowNoIndices.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            generator.writeKey("expand_wildcards");
            generator.writeStartArray();
            for (ExpandWildcard item0 : this.expandWildcards) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.ignoreThrottled != null) {
            generator.writeKey("ignore_throttled");
            generator.write(this.ignoreThrottled.booleanValue());
        }
    }

    protected static void setupIndicesOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoIndices, JsonpDeserializer.booleanDeserializer(), "allow_no_indices");
        op.add(Builder::expandWildcards, JsonpDeserializer.arrayDeserializer(ExpandWildcard._DESERIALIZER), "expand_wildcards");
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::ignoreThrottled, JsonpDeserializer.booleanDeserializer(), "ignore_throttled");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndicesOptions> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean ignoreThrottled;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        @Override
        public IndicesOptions build() {
            this._checkSingleUse();
            return new IndicesOptions(this);
        }
    }
}

