/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DelayedDataCheckConfig
implements JsonpSerializable {
    @Nullable
    private final Time checkWindow;
    private final boolean enabled;
    public static final JsonpDeserializer<DelayedDataCheckConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelayedDataCheckConfig::setupDelayedDataCheckConfigDeserializer);

    private DelayedDataCheckConfig(Builder builder) {
        this.checkWindow = builder.checkWindow;
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
    }

    public static DelayedDataCheckConfig of(Function<Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time checkWindow() {
        return this.checkWindow;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkWindow != null) {
            generator.writeKey("check_window");
            this.checkWindow.serialize(generator, mapper);
        }
        generator.writeKey("enabled");
        generator.write(this.enabled);
    }

    protected static void setupDelayedDataCheckConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkWindow, Time._DESERIALIZER, "check_window");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DelayedDataCheckConfig> {
        @Nullable
        private Time checkWindow;
        private Boolean enabled;

        public final Builder checkWindow(@Nullable Time value) {
            this.checkWindow = value;
            return this;
        }

        public final Builder checkWindow(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.checkWindow(fn.apply(new Time.Builder()).build());
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        public DelayedDataCheckConfig build() {
            this._checkSingleUse();
            return new DelayedDataCheckConfig(this);
        }
    }
}

