/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ChainInput;
import co.elastic.clients.elasticsearch.watcher.HttpInput;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInput;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Input
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Input> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Input::setupInputDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Input(InputVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._inputKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Input(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Input of(Function<Builder, ObjectBuilder<Input>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isChain() {
        return this._kind == Kind.Chain;
    }

    public ChainInput chain() {
        return (ChainInput)TaggedUnionUtils.get(this, Kind.Chain);
    }

    public boolean isHttp() {
        return this._kind == Kind.Http;
    }

    public HttpInput http() {
        return (HttpInput)TaggedUnionUtils.get(this, Kind.Http);
    }

    public boolean isSearch() {
        return this._kind == Kind.Search;
    }

    public SearchInput search() {
        return (SearchInput)TaggedUnionUtils.get(this, Kind.Search);
    }

    public boolean isSimple() {
        return this._kind == Kind.Simple;
    }

    public Map<String, JsonData> simple() {
        return (Map)TaggedUnionUtils.get(this, Kind.Simple);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Simple: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        ((JsonData)item0.getValue()).serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chain, ChainInput._DESERIALIZER, "chain");
        op.add(Builder::http, HttpInput._DESERIALIZER, "http");
        op.add(Builder::search, SearchInput._DESERIALIZER, "search");
        op.add(Builder::simple, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "simple");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Input> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Input> chain(ChainInput v) {
            this._kind = Kind.Chain;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Input> chain(Function<ChainInput.Builder, ObjectBuilder<ChainInput>> fn) {
            return this.chain(fn.apply(new ChainInput.Builder()).build());
        }

        public ObjectBuilder<Input> http(HttpInput v) {
            this._kind = Kind.Http;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Input> http(Function<HttpInput.Builder, ObjectBuilder<HttpInput>> fn) {
            return this.http(fn.apply(new HttpInput.Builder()).build());
        }

        public ObjectBuilder<Input> search(SearchInput v) {
            this._kind = Kind.Search;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Input> search(Function<SearchInput.Builder, ObjectBuilder<SearchInput>> fn) {
            return this.search(fn.apply(new SearchInput.Builder()).build());
        }

        public ObjectBuilder<Input> simple(Map<String, JsonData> v) {
            this._kind = Kind.Simple;
            this._value = v;
            return this;
        }

        @Override
        public Input build() {
            this._checkSingleUse();
            return new Input(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Chain("chain"),
        Http("http"),
        Search("search"),
        Simple("simple");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

